/*
 * Decompiled with CFR 0.152.
 */
package org.jongo;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.bson.types.ObjectId;
import org.jongo.ObjectIdUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveObjectIdUpdater
implements ObjectIdUpdater {
    private final Map<Class<?>, Field> fieldCache = new HashMap();
    private final IdFieldSelector idFieldSelector;

    public ReflectiveObjectIdUpdater(IdFieldSelector idFieldSelector) {
        this.idFieldSelector = idFieldSelector;
    }

    @Override
    public boolean mustGenerateObjectId(Object pojo) {
        Field idField = this.selectIdField(pojo.getClass());
        return idField != null && this.isAnEmptyObjectId(pojo, idField);
    }

    @Override
    public Object getId(Object pojo) {
        Field idField = this.selectIdField(pojo.getClass());
        if (idField != null) {
            try {
                idField.setAccessible(true);
                Object id = idField.get(pojo);
                if (id instanceof String && this.idFieldSelector.isObjectId(idField)) {
                    return new ObjectId(id.toString());
                }
                return id;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to obtain objectid from field" + idField.getName() + ", class: " + idField.getClass(), e);
            }
        }
        return null;
    }

    @Override
    public void setObjectId(Object newPojo, ObjectId id) {
        Field idField = this.selectIdField(newPojo.getClass());
        if (idField == null) {
            return;
        }
        if (!this.mustGenerateObjectId(newPojo)) {
            throw new IllegalArgumentException("Unable to set objectid on class: " + newPojo.getClass());
        }
        this.updateField(newPojo, id, idField);
    }

    private void updateField(Object target, ObjectId id, Field field2) {
        try {
            if (field2.getType().equals(ObjectId.class)) {
                field2.setAccessible(true);
                field2.set(target, id);
            } else if (field2.getType().equals(String.class)) {
                field2.setAccessible(true);
                field2.set(target, id.toString());
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable to set objectid on class: " + target.getClass(), e);
        }
    }

    private Field selectIdField(Class<?> clazz) {
        if (this.fieldCache.containsKey(clazz)) {
            return this.fieldCache.get(clazz);
        }
        Class<?> c = clazz;
        while (!Object.class.equals(c)) {
            for (Field f : c.getDeclaredFields()) {
                if (!this.idFieldSelector.isId(f)) continue;
                this.fieldCache.put(clazz, f);
                return f;
            }
            c = c.getSuperclass();
        }
        return null;
    }

    private boolean isAnEmptyObjectId(Object target, Field field2) {
        try {
            field2.setAccessible(true);
            return field2.get(target) == null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to obtain value from field" + field2.getName() + ", class: " + target.getClass(), e);
        }
    }

    public static interface IdFieldSelector {
        public boolean isId(Field var1);

        public boolean isObjectId(Field var1);
    }
}

