/*
 * Decompiled with CFR 0.152.
 */
package org.jongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import org.bson.LazyBSONObject;
import org.jongo.query.Query;
import org.jongo.query.QueryFactory;

public class Update {
    private final DBCollection collection;
    private final Query query;
    private final QueryFactory queryFactory;
    private WriteConcern writeConcern;
    private boolean upsert = false;
    private boolean multi = false;

    Update(DBCollection collection, WriteConcern writeConcern, QueryFactory queryFactory, String query, Object ... parameters) {
        this.collection = collection;
        this.writeConcern = writeConcern;
        this.queryFactory = queryFactory;
        this.query = this.createQuery(query, parameters);
    }

    public WriteResult with(String modifier) {
        return this.with(modifier, new Object[0]);
    }

    public WriteResult with(String modifier, Object ... parameters) {
        Query updateQuery = this.queryFactory.createQuery(modifier, parameters);
        return this.collection.update(this.query.toDBObject(), updateQuery.toDBObject(), this.upsert, this.multi, this.writeConcern);
    }

    public WriteResult with(Object pojo) {
        DBObject updateDbo = this.queryFactory.createQuery("{$set:#}", pojo).toDBObject();
        this.removeIdField(updateDbo);
        return this.collection.update(this.query.toDBObject(), updateDbo, this.upsert, this.multi, this.writeConcern);
    }

    private void removeIdField(DBObject updateDbo) {
        DBObject pojoAsDbo = (DBObject)updateDbo.get("$set");
        if (pojoAsDbo.containsField("_id")) {
            if (pojoAsDbo instanceof LazyBSONObject) {
                BasicDBObject expanded = new BasicDBObject();
                expanded.putAll(pojoAsDbo);
                updateDbo.put("$set", expanded);
                pojoAsDbo = expanded;
            }
            pojoAsDbo.removeField("_id");
        }
    }

    public Update upsert() {
        this.upsert = true;
        return this;
    }

    public Update multi() {
        this.multi = true;
        return this;
    }

    private Query createQuery(String query, Object[] parameters) {
        try {
            return this.queryFactory.createQuery(query, parameters);
        }
        catch (Exception e) {
            String message = String.format("Unable execute update operation using query %s", query);
            throw new IllegalArgumentException(message, e);
        }
    }
}

