/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.bson;

import com.mongodb.DB;
import com.mongodb.DBCallback;
import com.mongodb.DBCollection;
import com.mongodb.DBDecoder;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBRef;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.LazyDBCallback;
import com.mongodb.LazyDBDecoder;
import com.mongodb.gridfs.GridFSDBFile;
import java.util.Iterator;
import org.bson.LazyBSONCallback;
import org.jongo.bson.RelaxedLazyDBObject;

public class BsonDBDecoder
extends LazyDBDecoder
implements DBDecoder {
    public static final DBDecoderFactory FACTORY = new BsonDBDecoderFactory();

    private BsonDBDecoder() {
    }

    public DBCallback getDBCallback(DBCollection collection) {
        return new BsonDBCallback(collection);
    }

    private static class BsonDBCallback
    extends LazyDBCallback {
        private final DB db;
        private final DBCollection collection;

        public BsonDBCallback(DBCollection collection) {
            super(collection);
            this.collection = collection;
            this.db = collection == null ? null : collection.getDB();
        }

        public Object createObject(byte[] data, int offset) {
            if (GridFSDBFile.class.equals((Object)this.collection.getObjectClass())) {
                return DefaultDBDecoder.FACTORY.create().decode(data, this.collection);
            }
            RelaxedLazyDBObject dbo = new RelaxedLazyDBObject(data, new LazyBSONCallback());
            Iterator<String> it = dbo.keySet().iterator();
            if (it.hasNext() && it.next().equals("$ref") && dbo.containsField("$id")) {
                return new DBRef(this.db, dbo);
            }
            return dbo;
        }
    }

    private static class BsonDBDecoderFactory
    implements DBDecoderFactory {
        private BsonDBDecoderFactory() {
        }

        public DBDecoder create() {
            return new BsonDBDecoder();
        }
    }
}

