/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.bson;

import com.mongodb.DBEncoder;
import com.mongodb.DBObject;
import com.mongodb.DefaultDBEncoder;
import org.bson.BSONObject;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.OutputBuffer;
import org.jongo.bson.BsonDocument;

class BufferedBsonDocument
implements BsonDocument {
    private final OutputBuffer buffer = new BasicOutputBuffer();
    private final DBObject dbo;

    BufferedBsonDocument(DBObject dbo) {
        this.dbo = dbo;
        this.encode(this.dbo);
    }

    private void encode(BSONObject dbo) {
        DBEncoder dbEncoder = DefaultDBEncoder.FACTORY.create();
        dbEncoder.writeObject(this.buffer, dbo);
    }

    public int getSize() {
        return this.buffer.size();
    }

    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    public DBObject toDBObject() {
        return this.dbo;
    }

    public String toString() {
        return this.dbo.toString();
    }
}

