/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.bson;

import com.mongodb.DBObject;
import com.mongodb.LazyDBObject;
import org.bson.LazyBSONCallback;
import org.bson.io.BSONByteBuffer;
import org.jongo.bson.BsonDocument;

class LazyBsonDocument
implements BsonDocument {
    private final byte[] bytes;

    LazyBsonDocument(byte[] bytes) {
        this.bytes = bytes;
    }

    public int getSize() {
        return BSONByteBuffer.wrap(this.bytes).getInt(0);
    }

    public byte[] toByteArray() {
        return this.bytes;
    }

    public DBObject toDBObject() {
        return new LazyDBObject(this.bytes, new LazyBSONCallback());
    }

    public String toString() {
        return this.toDBObject().toString();
    }
}

