/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.marshall.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jongo.Mapper;
import org.jongo.ObjectIdUpdater;
import org.jongo.ReflectiveObjectIdUpdater;
import org.jongo.marshall.Marshaller;
import org.jongo.marshall.Unmarshaller;
import org.jongo.marshall.jackson.JacksonEngine;
import org.jongo.marshall.jackson.JacksonIdFieldSelector;
import org.jongo.marshall.jackson.configuration.AbstractMappingBuilder;
import org.jongo.query.BsonQueryFactory;
import org.jongo.query.QueryFactory;

public class JacksonMapper
implements Mapper {
    private final JacksonEngine engine;
    private final ObjectIdUpdater objectIdUpdater;
    private final QueryFactory queryFactory;

    private JacksonMapper(JacksonEngine engine, QueryFactory queryFactory, ObjectIdUpdater objectIdUpdater) {
        this.engine = engine;
        this.queryFactory = queryFactory;
        this.objectIdUpdater = objectIdUpdater;
    }

    public Marshaller getMarshaller() {
        return this.engine;
    }

    public Unmarshaller getUnmarshaller() {
        return this.engine;
    }

    public ObjectIdUpdater getObjectIdUpdater() {
        return this.objectIdUpdater;
    }

    public QueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends AbstractMappingBuilder<Builder> {
        private QueryFactory queryFactory;
        private ObjectIdUpdater objectIdUpdater;

        public Builder() {
        }

        public Builder(ObjectMapper mapper) {
            super(mapper);
        }

        public Mapper build() {
            JacksonEngine jacksonEngine = new JacksonEngine(this.createMapping());
            if (this.queryFactory == null) {
                this.queryFactory = new BsonQueryFactory(jacksonEngine);
            }
            if (this.objectIdUpdater == null) {
                this.objectIdUpdater = new ReflectiveObjectIdUpdater(new JacksonIdFieldSelector());
            }
            return new JacksonMapper(jacksonEngine, this.queryFactory, this.objectIdUpdater);
        }

        public Builder withQueryFactory(QueryFactory factory) {
            this.queryFactory = factory;
            return this.getBuilderInstance();
        }

        public Builder withObjectIdUpdater(ObjectIdUpdater objectIdUpdater) {
            this.objectIdUpdater = objectIdUpdater;
            return this.getBuilderInstance();
        }

        @Override
        protected Builder getBuilderInstance() {
            return this;
        }
    }
}

