/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.marshall.jackson.bson4jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.io.IOException;
import java.util.Date;
import org.bson.types.Binary;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;

class BsonDeserializers
extends SimpleDeserializers {
    public BsonDeserializers() {
        this.addDeserializer(Date.class, new DateDeserializer());
        this.addDeserializer(MinKey.class, new MinKeyDeserializer());
        this.addDeserializer(MaxKey.class, new MaxKeyDeserializer());
        this.addDeserializer(Binary.class, new BinaryDeserializer());
        this.addDeserializer(DBObject.class, new NativeDeserializer());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BinaryDeserializer
    extends JsonDeserializer<Binary> {
        private BinaryDeserializer() {
        }

        @Override
        public Binary deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Object object = jp.getEmbeddedObject();
            return new Binary((byte[])object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NativeDeserializer<T>
    extends JsonDeserializer<T> {
        private NativeDeserializer() {
        }

        @Override
        public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String asString = jp.readValueAsTree().toString();
            return (T)JSON.parse(asString);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MaxKeyDeserializer
    extends JsonDeserializer<MaxKey> {
        private MaxKeyDeserializer() {
        }

        @Override
        public MaxKey deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return new MaxKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MinKeyDeserializer
    extends JsonDeserializer<MinKey> {
        private MinKeyDeserializer() {
        }

        @Override
        public MinKey deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return new MinKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateDeserializer
    extends JsonDeserializer<Date> {
        private DateDeserializer() {
        }

        @Override
        public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Object deserialized = jp.getEmbeddedObject();
            if (deserialized instanceof Long) {
                return this.getDateFromBackwardFormat((Long)deserialized);
            }
            return (Date)deserialized;
        }

        private Date getDateFromBackwardFormat(Long deserialized) {
            return new Date(deserialized);
        }
    }
}

