/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.marshall.jackson.bson4jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import java.io.IOException;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.jongo.marshall.jackson.bson4jackson.MongoBsonGenerator;

class BsonSerializers
extends SimpleSerializers {
    public BsonSerializers() {
        this.addSerializer(ObjectId.class, new BsonObjectIdSerializer());
        this.addSerializer(BSONTimestamp.class, new BSONTimestampSerializer());
        this.addSerializer(MinKey.class, new MinKeySerializer());
        this.addSerializer(MaxKey.class, new MaxKeySerializer());
        this.addSerializer(Binary.class, new BinarySerializer());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BinarySerializer
    extends JsonSerializer<Binary> {
        BinarySerializer() {
        }

        @Override
        public void serialize(Binary obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            ((MongoBsonGenerator)jsonGenerator).writeBinary(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BsonObjectIdSerializer
    extends JsonSerializer<ObjectId> {
        BsonObjectIdSerializer() {
        }

        @Override
        public void serialize(ObjectId obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            ((MongoBsonGenerator)jsonGenerator).writeNativeObjectId(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BSONTimestampSerializer
    extends JsonSerializer<BSONTimestamp> {
        BSONTimestampSerializer() {
        }

        @Override
        public void serialize(BSONTimestamp obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            ((MongoBsonGenerator)jsonGenerator).writeBSONTimestamp(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MinKeySerializer
    extends JsonSerializer<MinKey> {
        MinKeySerializer() {
        }

        @Override
        public void serialize(MinKey obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            ((MongoBsonGenerator)jsonGenerator).writeMinKey(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MaxKeySerializer
    extends JsonSerializer<MaxKey> {
        MaxKeySerializer() {
        }

        @Override
        public void serialize(MaxKey obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            ((MongoBsonGenerator)jsonGenerator).writeMaxKey(obj);
        }
    }
}

