/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.marshall.jackson.bson4jackson;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.io.IOContext;
import de.undercouch.bson4jackson.BsonFactory;
import de.undercouch.bson4jackson.BsonGenerator;
import de.undercouch.bson4jackson.BsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jongo.marshall.jackson.bson4jackson.MongoBsonGenerator;
import org.jongo.marshall.jackson.bson4jackson.MongoBsonParser;

public class MongoBsonFactory
extends BsonFactory {
    public static BsonFactory createFactory() {
        MongoBsonFactory factory = new MongoBsonFactory();
        factory.enable(BsonParser.Feature.HONOR_DOCUMENT_LENGTH);
        return factory;
    }

    protected BsonParser _createParser(InputStream in, IOContext ctxt) {
        MongoBsonParser p = new MongoBsonParser(ctxt, this._parserFeatures, this._bsonParserFeatures, in);
        ObjectCodec codec = this.getCodec();
        if (codec != null) {
            p.setCodec(codec);
        }
        return p;
    }

    public BsonGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        IOContext ctxt = this._createContext(out, true);
        ctxt.setEncoding(enc);
        if (enc == JsonEncoding.UTF8 && this._outputDecorator != null) {
            out = this._outputDecorator.decorate(ctxt, out);
        }
        MongoBsonGenerator g = new MongoBsonGenerator(this._generatorFeatures, this._bsonGeneratorFeatures, out);
        ObjectCodec codec = this.getCodec();
        if (codec != null) {
            g.setCodec(codec);
        }
        return g;
    }
}

