/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.marshall.jackson.bson4jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.io.IOContext;
import de.undercouch.bson4jackson.BsonParser;
import de.undercouch.bson4jackson.types.Timestamp;
import java.io.IOException;
import java.io.InputStream;
import org.bson.types.BSONTimestamp;
import org.bson.types.ObjectId;

class MongoBsonParser
extends BsonParser {
    public MongoBsonParser(IOContext ctxt, int jsonFeatures, int bsonFeatures, InputStream in) {
        super(ctxt, jsonFeatures, bsonFeatures, in);
    }

    public Object getEmbeddedObject() throws IOException, JsonParseException {
        Object object = super.getEmbeddedObject();
        if (object instanceof de.undercouch.bson4jackson.types.ObjectId) {
            return this.convertToNativeObjectId((de.undercouch.bson4jackson.types.ObjectId)object);
        }
        if (object instanceof Timestamp) {
            return this.convertToBSONTimestamp((Timestamp)object);
        }
        return object;
    }

    private Object convertToBSONTimestamp(Timestamp ts) {
        return new BSONTimestamp(ts.getTime(), ts.getInc());
    }

    private ObjectId convertToNativeObjectId(de.undercouch.bson4jackson.types.ObjectId id) {
        return new ObjectId(id.getTime(), id.getMachine(), id.getInc());
    }
}

