/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.marshall.jackson.configuration;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.ArrayList;
import java.util.List;
import org.jongo.marshall.jackson.bson4jackson.BsonModule;
import org.jongo.marshall.jackson.bson4jackson.MongoBsonFactory;
import org.jongo.marshall.jackson.configuration.DefaultReaderCallback;
import org.jongo.marshall.jackson.configuration.DefaultWriterCallback;
import org.jongo.marshall.jackson.configuration.DeserializationFeatureModifier;
import org.jongo.marshall.jackson.configuration.MapperFeatureModifier;
import org.jongo.marshall.jackson.configuration.MapperModifier;
import org.jongo.marshall.jackson.configuration.Mapping;
import org.jongo.marshall.jackson.configuration.PropertyModifier;
import org.jongo.marshall.jackson.configuration.ReaderCallback;
import org.jongo.marshall.jackson.configuration.SerializationFeatureModifier;
import org.jongo.marshall.jackson.configuration.ViewReaderCallback;
import org.jongo.marshall.jackson.configuration.ViewWriterCallback;
import org.jongo.marshall.jackson.configuration.VisibilityModifier;
import org.jongo.marshall.jackson.configuration.WriterCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMappingBuilder<T extends AbstractMappingBuilder<T>> {
    private final SimpleModule module = new SimpleModule("jongo-custom-module");
    private final ObjectMapper mapper;
    private final List<MapperModifier> modifiers;
    private ReaderCallback readerCallback;
    private WriterCallback writerCallback;
    private MapperModifier visibilityModifier = new VisibilityModifier();

    public AbstractMappingBuilder() {
        this(new ObjectMapper(MongoBsonFactory.createFactory()));
        this.registerModule(new BsonModule());
        this.addModifier(new PropertyModifier());
    }

    public AbstractMappingBuilder(ObjectMapper mapper) {
        this.mapper = mapper;
        this.modifiers = new ArrayList<MapperModifier>();
        this.registerModule(this.module);
    }

    protected abstract T getBuilderInstance();

    protected Mapping createMapping() {
        this.addModifier(this.visibilityModifier);
        for (MapperModifier modifier : this.modifiers) {
            modifier.modify(this.mapper);
        }
        this.setDefaultCallbacksIfNone();
        return new Mapping(this.mapper, this.readerCallback, this.writerCallback);
    }

    private void setDefaultCallbacksIfNone() {
        if (this.readerCallback == null) {
            this.readerCallback = new DefaultReaderCallback();
        }
        if (this.writerCallback == null) {
            this.writerCallback = new DefaultWriterCallback();
        }
    }

    public <S> T addDeserializer(Class<S> type, JsonDeserializer<S> deserializer) {
        this.module.addDeserializer(type, deserializer);
        return this.getBuilderInstance();
    }

    public <S> T addSerializer(Class<S> type, JsonSerializer<S> serializer) {
        this.module.addSerializer(type, serializer);
        return this.getBuilderInstance();
    }

    public T registerModule(final Module module) {
        this.modifiers.add(new MapperModifier(){

            public void modify(ObjectMapper mapper) {
                mapper.registerModule(module);
            }
        });
        return this.getBuilderInstance();
    }

    public T withView(Class<?> viewClass) {
        this.setReaderCallback(new ViewReaderCallback(viewClass));
        this.setWriterCallback(new ViewWriterCallback(viewClass));
        return this.getBuilderInstance();
    }

    public T setVisibilityChecker(final VisibilityChecker<?> visibilityChecker) {
        this.visibilityModifier = new MapperModifier(){

            public void modify(ObjectMapper mapper) {
                mapper.setVisibilityChecker(visibilityChecker);
            }
        };
        return this.getBuilderInstance();
    }

    public T enable(DeserializationFeature feature) {
        this.modifiers.add(new DeserializationFeatureModifier(feature, true));
        return this.getBuilderInstance();
    }

    public T enable(SerializationFeature feature) {
        this.modifiers.add(new SerializationFeatureModifier(feature, true));
        return this.getBuilderInstance();
    }

    public T enable(MapperFeature feature) {
        this.modifiers.add(new MapperFeatureModifier(feature, true));
        return this.getBuilderInstance();
    }

    public T disable(DeserializationFeature feature) {
        this.modifiers.add(new DeserializationFeatureModifier(feature, false));
        return this.getBuilderInstance();
    }

    public T disable(SerializationFeature feature) {
        this.modifiers.add(new SerializationFeatureModifier(feature, false));
        return this.getBuilderInstance();
    }

    public T disable(MapperFeature feature) {
        this.modifiers.add(new MapperFeatureModifier(feature, false));
        return this.getBuilderInstance();
    }

    public T addModifier(MapperModifier modifier) {
        this.modifiers.add(modifier);
        return this.getBuilderInstance();
    }

    public T setReaderCallback(ReaderCallback readerCallback) {
        this.readerCallback = readerCallback;
        return this.getBuilderInstance();
    }

    public T setWriterCallback(WriterCallback writerCallback) {
        this.writerCallback = writerCallback;
        return this.getBuilderInstance();
    }
}

