/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.sqlprofiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.Iterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.jahia.sqlprofiler.QueryEntry;
import org.jahia.sqlprofiler.QueryStatEntry;
import org.jahia.sqlprofiler.QueryStatistics;

public class LogFileParser {
    private static final String GENERATED_INDEXES_FILE = "indexes.sql";
    private QueryStatistics queryStats = new QueryStatistics();

    public void parseFile(String fileName, boolean displayQueries, boolean generateIndexes) throws FileNotFoundException, IOException, RESyntaxException {
        File inputFile = new File(fileName);
        long fileLength = inputFile.length();
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        System.out.print("Processing file : " + fileName + "...");
        RE selectWithOrderQuery = new RE("select[:blank:].*[:blank:]from[:blank:].*[:blank:]where[:blank:](.*)[:blank:]order[:blank:]by(.*)([:blank:](asc)|(desc))?");
        RE selectQuery = new RE("select[:blank:].*[:blank:]from[:blank:].*[:blank:]where[:blank:](.*)");
        String curLine = null;
        String lowerCurLine = null;
        int lineCount = 0;
        long curFilePos = 0L;
        int lastCompletion = 0;
        while ((curLine = in.readLine()) != null) {
            double completionPercentage;
            int roundedCompletion;
            curFilePos += (long)curLine.getBytes().length;
            ++lineCount;
            lowerCurLine = curLine.toLowerCase();
            String occurenceString = null;
            if (selectWithOrderQuery.match(lowerCurLine)) {
                occurenceString = selectWithOrderQuery.getParen(0);
            } else if (selectQuery.match(lowerCurLine)) {
                occurenceString = selectQuery.getParen(0);
            }
            if (occurenceString != null) {
                QueryEntry queryEntry = new QueryEntry();
                queryEntry.setSqlStatement(occurenceString);
                this.queryStats.processSQL(queryEntry);
            }
            if ((roundedCompletion = new Double(completionPercentage = 100.0 * (double)curFilePos / (double)fileLength).intValue()) % 10 == 0 && lastCompletion != roundedCompletion) {
                System.out.print(roundedCompletion + "%...");
                lastCompletion = roundedCompletion;
            }
            if (curLine != null) continue;
        }
        System.out.println("100%");
        System.out.println("Lines read=" + lineCount + " occurencesFound=" + this.queryStats.getOccurenceCount());
    }

    private void displayOccurenceStats(boolean displayQueries) {
        Iterator queryStatByOccurenceIter = this.queryStats.getQueryStatsByOccurence().iterator();
        while (queryStatByOccurenceIter.hasNext()) {
            QueryStatEntry curQueryStat = (QueryStatEntry)queryStatByOccurenceIter.next();
            double occurencePourcentage = 100.0 * (double)curQueryStat.getOccurences() / (double)this.queryStats.getOccurenceCount();
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(2);
            System.out.println(nf.format(occurencePourcentage) + "% Occurences=" + curQueryStat.getOccurences() + " Table(s)=" + curQueryStat.getTableNames() + " Column(s)=" + curQueryStat.getColumnNames());
            if (!displayQueries) continue;
            Iterator queryIter = curQueryStat.getQueries().iterator();
            while (queryIter.hasNext()) {
                String curQuery = (String)queryIter.next();
                System.out.println("    " + curQuery);
            }
        }
    }

    public static void main(String[] args) {
        LogFileParser logfileParser = new LogFileParser();
        PosixParser parser = new PosixParser();
        boolean displayQueries = false;
        boolean generateIndexes = false;
        String indexesFileName = GENERATED_INDEXES_FILE;
        Options options = new Options();
        OptionBuilder.withLongOpt("indexes");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName("filename");
        OptionBuilder.withDescription("the file name to which to output the indexes ");
        Option indexesOption = OptionBuilder.create('i');
        options.addOption("q", "with-queries", false, "Display the queries along with the table and column statistics");
        options.addOption(indexesOption);
        options.addOption("h", "help", false, "Print this help message");
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption('h') || args.length == 0) {
                HelpFormatter helpFormatter = new HelpFormatter();
                StringWriter strWriter = new StringWriter();
                PrintWriter ptrWriter = new PrintWriter(strWriter);
                helpFormatter.printHelp(ptrWriter, 80, "java -jar sqlprofiler.jar log_file_name [options]", "", options, 10, 10, "");
                System.out.println(strWriter.toString());
                System.exit(0);
            }
            if (line.hasOption('q')) {
                displayQueries = true;
                System.out.println("Query display activated.");
            }
            if (line.hasOption('i')) {
                generateIndexes = true;
                String optionIndexesFileName = line.getOptionValue('i');
                if (optionIndexesFileName != null) {
                    indexesFileName = optionIndexesFileName;
                }
                System.out.println("Indexes generation in file [" + indexesFileName + "] activated.");
            }
        }
        catch (ParseException exp) {
            System.out.println("Unexpected exception:");
            exp.printStackTrace();
            System.exit(0);
        }
        try {
            logfileParser.parseFile(args[0], displayQueries, generateIndexes);
            logfileParser.displayOccurenceStats(displayQueries);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (RESyntaxException rese) {
            rese.printStackTrace();
        }
        if (generateIndexes) {
            System.out.print("Writing indexes SQL to file [" + indexesFileName + "]...");
            try {
                FileWriter fileWriter = new FileWriter(indexesFileName);
                PrintWriter writer = new PrintWriter(fileWriter);
                Iterator indexNameIter = logfileParser.queryStats.getGeneratedIndexes().keySet().iterator();
                while (indexNameIter.hasNext()) {
                    String curIndexName = (String)indexNameIter.next();
                    String indexSql = (String)logfileParser.queryStats.getGeneratedIndexes().get(curIndexName);
                    writer.println(indexSql);
                }
                writer.flush();
                writer.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            System.out.println("done.");
        }
    }
}

