/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.sqlprofiler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.jahia.sqlprofiler.QueryEntry;

public class QueryStatEntry
implements Comparable {
    private ArrayList tableNames = new ArrayList();
    private ArrayList columnNames = new ArrayList();
    private Set queries = new TreeSet();
    private int occurences = 0;
    private long totalElapsedTime = 0L;

    public QueryStatEntry() {
    }

    public QueryStatEntry(ArrayList tableNames, ArrayList columnNames) {
        Iterator tableNameIter = tableNames.iterator();
        while (tableNameIter.hasNext()) {
            String curTableName = (String)tableNameIter.next();
            if (this.tableNames.contains(curTableName)) continue;
            this.tableNames.add(curTableName);
        }
        Iterator columnNameIter = columnNames.iterator();
        while (columnNameIter.hasNext()) {
            String curColumnName = (String)columnNameIter.next();
            if (this.columnNames.contains(curColumnName)) continue;
            this.columnNames.add(curColumnName);
        }
    }

    public ArrayList getTableNames() {
        return this.tableNames;
    }

    public ArrayList getColumnNames() {
        return this.columnNames;
    }

    public int getOccurences() {
        return this.occurences;
    }

    public long getTotalElapsedTime() {
        return this.totalElapsedTime;
    }

    public void incOccurences() {
        ++this.occurences;
    }

    public void incTotalElapseTime(long elapsedTime) {
        this.totalElapsedTime += elapsedTime;
    }

    public void addQuery(QueryEntry query) {
        this.queries.add(query);
    }

    public Set getQueries() {
        return this.queries;
    }

    public String getKey() {
        String hashCodeStr = this.tableNames.toString() + "_" + this.columnNames.toString();
        return hashCodeStr;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof QueryStatEntry) {
            QueryStatEntry right = (QueryStatEntry)o;
            return this.getKey().equals(right.getKey());
        }
        return false;
    }

    public int compareTo(Object o) throws ClassCastException {
        Long rightElapsedTime;
        QueryStatEntry right = (QueryStatEntry)o;
        Long leftElapsedTime = new Long(this.getTotalElapsedTime());
        int compareElapsed = -leftElapsedTime.compareTo(rightElapsedTime = new Long(right.getTotalElapsedTime()));
        if (compareElapsed != 0) {
            return compareElapsed;
        }
        Integer left = new Integer(this.occurences);
        return -left.compareTo(new Integer(right.getOccurences()));
    }
}

