/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.sqlprofiler;

import antlr.collections.AST;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.jahia.sqlparser.SqlLexer;
import org.jahia.sqlparser.SqlParser;
import org.jahia.sqlparser.SqlTreeParser;
import org.jahia.sqlprofiler.QueryEntry;
import org.jahia.sqlprofiler.QueryStatEntry;

public class QueryStatistics {
    private static final Logger logger = Logger.getLogger(class$org$jahia$sqlprofiler$QueryStatistics == null ? (class$org$jahia$sqlprofiler$QueryStatistics = QueryStatistics.class$("org.jahia.sqlprofiler.QueryStatistics")) : class$org$jahia$sqlprofiler$QueryStatistics);
    Map occurences = new TreeMap();
    Map queryStatEntries = new TreeMap();
    private long totalElapsedQueryTime = 0L;
    static /* synthetic */ Class class$org$jahia$sqlprofiler$QueryStatistics;

    public void clear() {
        this.occurences.clear();
        this.queryStatEntries.clear();
        this.totalElapsedQueryTime = 0L;
    }

    public Integer processSQL(QueryEntry queryEntry) {
        Integer occurenceCount = null;
        String sqlStatement = queryEntry.getSqlStatement().toLowerCase();
        if (sqlStatement.trim().startsWith("select") || sqlStatement.trim().startsWith("insert") || sqlStatement.trim().startsWith("update") || sqlStatement.trim().startsWith("delete")) {
            occurenceCount = (Integer)this.occurences.get(sqlStatement);
            if (occurenceCount == null) {
                occurenceCount = new Integer(0);
            }
            occurenceCount = new Integer(occurenceCount + 1);
            this.occurences.put(sqlStatement, occurenceCount);
            this.parseSQL(queryEntry);
        }
        return occurenceCount;
    }

    public Set getQueryStatsByOccurence() {
        TreeSet<QueryStatEntry> queryStatByOccurence = new TreeSet<QueryStatEntry>();
        Iterator queryStatIter = this.queryStatEntries.keySet().iterator();
        while (queryStatIter.hasNext()) {
            String curQueryStatKey = (String)queryStatIter.next();
            QueryStatEntry curQueryStatEntry = (QueryStatEntry)this.queryStatEntries.get(curQueryStatKey);
            queryStatByOccurence.add(curQueryStatEntry);
        }
        return queryStatByOccurence;
    }

    public Map getGeneratedIndexes() {
        TreeMap<String, String> generatedIndexes = new TreeMap<String, String>();
        Iterator queryStatByOccurenceIter = this.getQueryStatsByOccurence().iterator();
        while (queryStatByOccurenceIter.hasNext()) {
            String tableName;
            QueryStatEntry curQueryStat = (QueryStatEntry)queryStatByOccurenceIter.next();
            if (curQueryStat.getTableNames().size() != 1 || curQueryStat.getColumnNames().size() <= 0 || !(tableName = (String)curQueryStat.getTableNames().iterator().next()).startsWith("SEL_")) continue;
            tableName = tableName.substring(4, tableName.length());
            String indexName = tableName + "_index";
            String indexSuffix = "";
            int indexSuffixNumber = 1;
            while (generatedIndexes.containsKey(new String(indexName + indexSuffix))) {
                indexSuffix = Integer.toString(++indexSuffixNumber);
            }
            StringBuffer indexStrBuffer = new StringBuffer("CREATE INDEX ");
            indexStrBuffer.append(indexName);
            indexStrBuffer.append(indexSuffix);
            indexStrBuffer.append(" ON ");
            indexStrBuffer.append(tableName);
            indexStrBuffer.append(" ( ");
            Iterator columnNameIter = curQueryStat.getColumnNames().iterator();
            while (columnNameIter.hasNext()) {
                String curColumnName = (String)columnNameIter.next();
                indexStrBuffer.append(curColumnName);
                if (!columnNameIter.hasNext()) continue;
                indexStrBuffer.append(",");
            }
            indexStrBuffer.append(" ); ");
            generatedIndexes.put(new String(indexName + indexSuffix), indexStrBuffer.toString());
        }
        return generatedIndexes;
    }

    private void parseSQL(QueryEntry queryEntry) {
        try {
            SqlLexer lexer = new SqlLexer(new StringReader(queryEntry.getSqlStatement().toLowerCase()));
            SqlParser parser = new SqlParser(lexer);
            parser.start_rule();
            AST resultTree = parser.getAST();
            SqlTreeParser sqlTreeParser = new SqlTreeParser();
            String strSqlStatement = queryEntry.getSqlStatement().toLowerCase();
            if (strSqlStatement.trim().startsWith("select")) {
                sqlTreeParser.select_statement(resultTree);
            } else if (strSqlStatement.trim().startsWith("update")) {
                sqlTreeParser.update_command(resultTree);
            } else if (strSqlStatement.trim().startsWith("delete")) {
                sqlTreeParser.delete_command(resultTree);
            } else if (strSqlStatement.trim().startsWith("insert")) {
                sqlTreeParser.insert_command(resultTree);
            }
            QueryStatEntry newEntry = new QueryStatEntry(sqlTreeParser.getTableNames(), sqlTreeParser.getColumnNames());
            if (this.queryStatEntries.containsKey(newEntry.getKey())) {
                newEntry = (QueryStatEntry)this.queryStatEntries.get(newEntry.getKey());
            }
            newEntry.incOccurences();
            newEntry.addQuery(queryEntry);
            if (queryEntry.getElapsedTime() > 0L) {
                newEntry.incTotalElapseTime(queryEntry.getElapsedTime());
                this.totalElapsedQueryTime += queryEntry.getElapsedTime();
            }
            this.queryStatEntries.put(newEntry.getKey(), newEntry);
        }
        catch (Exception e) {
            System.err.println("exception: " + e);
        }
    }

    public int getOccurenceCount() {
        return this.occurences.size();
    }

    public long getTotalElapsedQueryTime() {
        return this.totalElapsedQueryTime;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

