/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.sqlprofiler;

import java.util.ArrayList;

public class StringDiff {
    private ArrayList leftSequences;
    private ArrayList rightSequences;
    private String left;
    private String right;
    private int sequenceCount;
    private int sameCharCount;

    public void diff(String left, String right) {
        int curLeftPos = 0;
        int curRightPos = 0;
        this.sameCharCount = 0;
        this.sequenceCount = 0;
        this.leftSequences = new ArrayList();
        this.rightSequences = new ArrayList();
        this.left = left;
        this.right = right;
        if (left == null) {
            return;
        }
        if (right == null) {
            return;
        }
        if (left.length() < 2 && right.startsWith(left)) {
            SequencePos leftSequencePos = new SequencePos(0, left.length());
            this.leftSequences.add(leftSequencePos);
            this.rightSequences.add(leftSequencePos);
            return;
        }
        if (right.length() < 2 && left.startsWith(right)) {
            SequencePos rightSequencePos = new SequencePos(0, right.length());
            this.leftSequences.add(rightSequencePos);
            this.rightSequences.add(rightSequencePos);
            return;
        }
        if (curLeftPos + 1 < left.length() && curRightPos + 1 < right.length() && left.charAt(curLeftPos + 1) == right.charAt(curRightPos + 1) || curLeftPos + 1 == left.length() && curRightPos + 1 == right.length()) {
            int leftSequenceStartPos = curLeftPos;
            int rightSequenceStartPos = curRightPos;
            while (curLeftPos < left.length() && curRightPos < right.length() && left.charAt(curLeftPos) == right.charAt(curRightPos)) {
                System.out.print(left.charAt(curLeftPos));
                ++this.sameCharCount;
                ++curLeftPos;
                ++curRightPos;
            }
            if (curLeftPos != 0) {
                ++this.sequenceCount;
                SequencePos newLeftSequencePos = new SequencePos(leftSequenceStartPos, curLeftPos);
                SequencePos newRightSequencePos = new SequencePos(rightSequenceStartPos, curRightPos);
                this.leftSequences.add(newLeftSequencePos);
                this.rightSequences.add(newRightSequencePos);
            }
        }
        while (curLeftPos < left.length()) {
            int tempRightPos = curRightPos;
            while (tempRightPos < right.length() && left.charAt(curLeftPos) != right.charAt(tempRightPos)) {
                ++tempRightPos;
            }
            if (tempRightPos == right.length()) {
                ++curLeftPos;
                continue;
            }
            if (curLeftPos + 1 < left.length() && tempRightPos + 1 < right.length() && left.charAt(curLeftPos + 1) == right.charAt(tempRightPos + 1) || curLeftPos + 1 == left.length() && tempRightPos + 1 == right.length()) {
                System.out.print("?");
                curRightPos = tempRightPos;
                int leftSequenceStartPos = curLeftPos;
                int rightSequenceStartPos = curRightPos;
                while (curLeftPos < left.length() && curRightPos < right.length() && left.charAt(curLeftPos) == right.charAt(curRightPos)) {
                    System.out.print(left.charAt(curLeftPos));
                    ++this.sameCharCount;
                    ++curLeftPos;
                    ++curRightPos;
                }
                SequencePos newLeftSequencePos = new SequencePos(leftSequenceStartPos, curLeftPos);
                SequencePos newRightSequencePos = new SequencePos(rightSequenceStartPos, curRightPos);
                this.leftSequences.add(newLeftSequencePos);
                this.rightSequences.add(newRightSequencePos);
                ++this.sequenceCount;
                continue;
            }
            ++curLeftPos;
        }
    }

    public ArrayList getLeftSequences() {
        return this.leftSequences;
    }

    public ArrayList getRightSequences() {
        return this.rightSequences;
    }

    public String getLeft() {
        return this.left;
    }

    public String getRight() {
        return this.right;
    }

    public int getSequenceCount() {
        return this.sequenceCount;
    }

    public int getSameCharCount() {
        return this.sameCharCount;
    }

    private static void displayResults(StringDiff stringDiff) {
        System.out.println("\nsameCharCount=" + stringDiff.getSameCharCount() + " sequenceCount=" + stringDiff.getSequenceCount());
        int i = 0;
        while (i < stringDiff.getLeftSequences().size()) {
            SequencePos leftSequencePos = (SequencePos)stringDiff.getLeftSequences().get(i);
            SequencePos rightSequencePos = (SequencePos)stringDiff.getRightSequences().get(i);
            System.out.println("sequence " + i + " : left=[" + leftSequencePos.getStartPos() + "," + leftSequencePos.getEndPos() + "]=[" + stringDiff.getLeft().substring(leftSequencePos.getStartPos(), leftSequencePos.getEndPos()) + "] right=[" + rightSequencePos.getStartPos() + "," + rightSequencePos.getEndPos() + "]=[" + stringDiff.getRight().substring(rightSequencePos.getStartPos(), rightSequencePos.getEndPos()) + "]");
            ++i;
        }
    }

    public static void main(String[] args) {
        StringDiff stringDiff = new StringDiff();
        stringDiff.diff("select * from jahia_fields_data where iasdfd_jahia_fields_data=10 order by id_jahia_fields_datba", "select * from jahia_fkjahdflields_data where id_jahiadsfa_fields_data=23 order by id_jahia_fields_data");
        StringDiff.displayResults(stringDiff);
        stringDiff.diff("select * from jahia_fields_data where id_jahia_fields_data=10 order by", "select * from jahia_fields_data where id_jahia_fields_data=10 order by id_jahia_fields_data");
        StringDiff.displayResults(stringDiff);
        stringDiff.diff("a", "a");
        StringDiff.displayResults(stringDiff);
        stringDiff.diff("", "");
        StringDiff.displayResults(stringDiff);
        stringDiff.diff("", "a");
        StringDiff.displayResults(stringDiff);
        stringDiff.diff("a", "");
        StringDiff.displayResults(stringDiff);
        stringDiff.diff("aa", "a");
        StringDiff.displayResults(stringDiff);
        stringDiff.diff("a", "aa");
        StringDiff.displayResults(stringDiff);
        stringDiff.diff("aa", "aa");
        StringDiff.displayResults(stringDiff);
        stringDiff.diff(null, null);
        StringDiff.displayResults(stringDiff);
        stringDiff.diff("a", null);
        StringDiff.displayResults(stringDiff);
        stringDiff.diff(null, "a");
        StringDiff.displayResults(stringDiff);
    }

    public class SequencePos {
        private int startPos;
        private int endPos;

        public SequencePos(int startPos, int endPos) {
            this.startPos = startPos;
            this.endPos = endPos;
        }

        public int getStartPos() {
            return this.startPos;
        }

        public int getEndPos() {
            return this.endPos;
        }
    }
}

