/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.sqlprofiler.gui;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.jahia.sqlprofiler.gui.EventDetails;
import org.jahia.sqlprofiler.gui.ProfileStatementTableModel;
import org.jahia.sqlprofiler.gui.QueryCountChartModel;
import org.jahia.sqlprofiler.gui.QueryTrafficChartModel;

class LoggerTableModel
extends AbstractTableModel {
    private static final Category LOG = Category.getInstance(class$org$jahia$sqlprofiler$gui$LoggerTableModel == null ? (class$org$jahia$sqlprofiler$gui$LoggerTableModel = LoggerTableModel.class$("org.jahia.sqlprofiler.gui.LoggerTableModel")) : class$org$jahia$sqlprofiler$gui$LoggerTableModel);
    private static final String[] COL_NAMES = new String[]{"Time", "Priority", "Trace", "Category", "NDC", "Message"};
    private static final EventDetails[] EMPTY_LIST = new EventDetails[0];
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss.SSS");
    private final Object mLock = new Object();
    private final SortedSet mAllEvents = new TreeSet(MY_COMP);
    private EventDetails[] mFilteredEvents = EMPTY_LIST;
    private final List mPendingEvents = new ArrayList();
    private boolean mPaused = false;
    private String mThreadFilter = "";
    private String mMessageFilter = "";
    private String mNDCFilter = "";
    private String mCategoryFilter = "";
    private Priority mPriorityFilter = Priority.DEBUG;
    private ProfileStatementTableModel profileStatementModel = null;
    private QueryCountChartModel queryCountChartModel = null;
    private QueryTrafficChartModel queryTrafficChartModel = null;
    private static final Comparator MY_COMP = new Comparator(){

        public int compare(Object aObj1, Object aObj2) {
            if (aObj1 == null && aObj2 == null) {
                return 0;
            }
            if (aObj1 == null) {
                return -1;
            }
            if (aObj2 == null) {
                return 1;
            }
            EventDetails le1 = (EventDetails)aObj1;
            EventDetails le2 = (EventDetails)aObj2;
            if (le1.getTimeStamp() < le2.getTimeStamp()) {
                return 1;
            }
            return -1;
        }
    };
    static /* synthetic */ Class class$org$jahia$sqlprofiler$gui$LoggerTableModel;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    LoggerTableModel() {
        Thread t = new Thread(new Processor());
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFilteredEvents.length;
        }
    }

    public int getColumnCount() {
        return COL_NAMES.length;
    }

    public String getColumnName(int aCol) {
        return COL_NAMES[aCol];
    }

    public Class getColumnClass(int aCol) {
        Class clazz = aCol == 2 ? (class$java$lang$Boolean == null ? (class$java$lang$Boolean = LoggerTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean) : (class$java$lang$Object == null ? (class$java$lang$Object = LoggerTableModel.class$("java.lang.Object")) : class$java$lang$Object);
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int aRow, int aCol) {
        Object object = this.mLock;
        synchronized (object) {
            EventDetails event = this.mFilteredEvents[aRow];
            if (aCol == 0) {
                return DATE_FORMATTER.format(new Date(event.getTimeStamp()));
            }
            if (aCol == 1) {
                return event.getPriority();
            }
            if (aCol == 2) {
                return event.getThrowableStrRep() == null ? Boolean.FALSE : Boolean.TRUE;
            }
            if (aCol == 3) {
                return event.getCategoryName();
            }
            if (aCol == 4) {
                return event.getNDC();
            }
            return event.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriorityFilter(Priority aPriority) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPriorityFilter = aPriority;
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadFilter(String aStr) {
        Object object = this.mLock;
        synchronized (object) {
            this.mThreadFilter = aStr.trim();
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageFilter(String aStr) {
        Object object = this.mLock;
        synchronized (object) {
            this.mMessageFilter = aStr.trim();
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNDCFilter(String aStr) {
        Object object = this.mLock;
        synchronized (object) {
            this.mNDCFilter = aStr.trim();
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCategoryFilter(String aStr) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCategoryFilter = aStr.trim();
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(EventDetails aEvent) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPendingEvents.add(aEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.mAllEvents.clear();
            this.mFilteredEvents = new EventDetails[0];
            this.mPendingEvents.clear();
            if (this.profileStatementModel != null) {
                this.profileStatementModel.clear();
                this.profileStatementModel.fireTableDataChanged();
            }
            this.fireTableDataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggle() {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl = this.mPaused = !this.mPaused;
            if (this.mPaused && this.profileStatementModel != null) {
                this.profileStatementModel.displayOccurenceStats(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaused() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPaused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventDetails getEventDetails(int aRow) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFilteredEvents[aRow];
        }
    }

    public void setProfileStatementModel(ProfileStatementTableModel profileStatementModel) {
        this.profileStatementModel = profileStatementModel;
    }

    public void setQueryCountChartModel(QueryCountChartModel queryCountChartModel) {
        this.queryCountChartModel = queryCountChartModel;
    }

    public void setQueryTrafficChartModel(QueryTrafficChartModel queryTrafficChartModel) {
        this.queryTrafficChartModel = queryTrafficChartModel;
    }

    private void updateFilteredEvents(boolean aInsertedToFront) {
        long start = System.currentTimeMillis();
        ArrayList<EventDetails> filtered = new ArrayList<EventDetails>();
        int size = this.mAllEvents.size();
        Iterator allEventIter = this.mAllEvents.iterator();
        while (allEventIter.hasNext()) {
            EventDetails event = (EventDetails)allEventIter.next();
            if (!this.matchFilter(event)) continue;
            filtered.add(event);
        }
        EventDetails lastFirst = this.mFilteredEvents.length == 0 ? null : this.mFilteredEvents[0];
        this.mFilteredEvents = filtered.toArray(EMPTY_LIST);
        if (aInsertedToFront && lastFirst != null) {
            int index = filtered.indexOf(lastFirst);
            if (index < 1) {
                LOG.warn("In strange state");
                this.fireTableDataChanged();
            } else {
                this.fireTableRowsInserted(0, index - 1);
            }
        } else {
            this.fireTableDataChanged();
        }
        long end = System.currentTimeMillis();
        LOG.debug("Total time [ms]: " + (end - start) + " in update, size: " + size);
    }

    private boolean matchFilter(EventDetails aEvent) {
        if (aEvent.getPriority().isGreaterOrEqual(this.mPriorityFilter) && aEvent.getThreadName().indexOf(this.mThreadFilter) >= 0 && aEvent.getCategoryName().indexOf(this.mCategoryFilter) >= 0 && (this.mNDCFilter.length() == 0 || aEvent.getNDC() != null && aEvent.getNDC().indexOf(this.mNDCFilter) >= 0)) {
            String rm = aEvent.getMessage();
            if (rm == null) {
                return this.mMessageFilter.length() == 0;
            }
            return rm.indexOf(this.mMessageFilter) >= 0;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Processor
    implements Runnable {
        private Processor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                Object object = LoggerTableModel.this.mLock;
                synchronized (object) {
                    if (LoggerTableModel.this.mPaused) {
                        continue;
                    }
                    boolean toHead = true;
                    boolean needUpdate = false;
                    boolean needUpdateProfiler = false;
                    Iterator it = LoggerTableModel.this.mPendingEvents.iterator();
                    while (it.hasNext()) {
                        EventDetails event = (EventDetails)it.next();
                        LoggerTableModel.this.mAllEvents.add(event);
                        if (event.getCategoryName().equals("p6spy")) {
                            needUpdateProfiler = true;
                            if (LoggerTableModel.this.profileStatementModel != null) {
                                LoggerTableModel.this.profileStatementModel.processP6Event(event.getMessage());
                            }
                        }
                        toHead = toHead && event == LoggerTableModel.this.mAllEvents.first();
                        boolean bl = needUpdate = needUpdate || LoggerTableModel.this.matchFilter(event);
                    }
                    if (LoggerTableModel.this.queryCountChartModel != null) {
                        LoggerTableModel.this.queryCountChartModel.update();
                    }
                    if (LoggerTableModel.this.queryTrafficChartModel != null) {
                        LoggerTableModel.this.queryTrafficChartModel.update();
                    }
                    if (LoggerTableModel.this.profileStatementModel != null && needUpdateProfiler) {
                        LoggerTableModel.this.profileStatementModel.sortAndUpdateTable();
                        LoggerTableModel.this.profileStatementModel.updateQueryStatsDisplay();
                    }
                    LoggerTableModel.this.mPendingEvents.clear();
                    if (needUpdate) {
                        LoggerTableModel.this.updateFilteredEvents(toHead);
                    }
                }
            }
        }
    }
}

