/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.sqlprofiler.gui;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.jahia.sqlprofiler.gui.EventDetails;
import org.jahia.sqlprofiler.gui.LogReceptionEvent;
import org.jahia.sqlprofiler.gui.LogReceptionListener;
import org.jahia.sqlprofiler.gui.LoggerTableModel;

class LoggingReceiver
extends Thread {
    private static final Logger LOG = Logger.getLogger(class$org$jahia$sqlprofiler$gui$LoggingReceiver == null ? (class$org$jahia$sqlprofiler$gui$LoggingReceiver = LoggingReceiver.class$("org.jahia.sqlprofiler.gui.LoggingReceiver")) : class$org$jahia$sqlprofiler$gui$LoggingReceiver);
    private final ServerSocket mSvrSock;
    EventListenerList listenerList = new EventListenerList();
    LogReceptionEvent defaultLogReceptionEvent = null;
    static /* synthetic */ Class class$org$jahia$sqlprofiler$gui$LoggingReceiver;
    static /* synthetic */ Class class$org$jahia$sqlprofiler$gui$LogReceptionListener;

    public void addLogReceptionListener(LogReceptionListener l) {
        this.listenerList.add(class$org$jahia$sqlprofiler$gui$LogReceptionListener == null ? (class$org$jahia$sqlprofiler$gui$LogReceptionListener = LoggingReceiver.class$("org.jahia.sqlprofiler.gui.LogReceptionListener")) : class$org$jahia$sqlprofiler$gui$LogReceptionListener, l);
    }

    public void removeLogReceptionListener(LogReceptionListener l) {
        this.listenerList.remove(class$org$jahia$sqlprofiler$gui$LogReceptionListener == null ? (class$org$jahia$sqlprofiler$gui$LogReceptionListener = LoggingReceiver.class$("org.jahia.sqlprofiler.gui.LogReceptionListener")) : class$org$jahia$sqlprofiler$gui$LogReceptionListener, l);
    }

    protected void fireLogReceptionConnected() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$org$jahia$sqlprofiler$gui$LogReceptionListener == null ? LoggingReceiver.class$("org.jahia.sqlprofiler.gui.LogReceptionListener") : class$org$jahia$sqlprofiler$gui$LogReceptionListener)) {
                if (this.defaultLogReceptionEvent == null) {
                    this.defaultLogReceptionEvent = new LogReceptionEvent(this);
                }
                ((LogReceptionListener)listeners[i + 1]).logReceptionConnected(this.defaultLogReceptionEvent);
            }
            i -= 2;
        }
    }

    protected void fireLogReceptionDisconnected() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$org$jahia$sqlprofiler$gui$LogReceptionListener == null ? LoggingReceiver.class$("org.jahia.sqlprofiler.gui.LogReceptionListener") : class$org$jahia$sqlprofiler$gui$LogReceptionListener)) {
                if (this.defaultLogReceptionEvent == null) {
                    this.defaultLogReceptionEvent = new LogReceptionEvent(this);
                }
                ((LogReceptionListener)listeners[i + 1]).logReceptionDisconnected(this.defaultLogReceptionEvent);
            }
            i -= 2;
        }
    }

    protected void fireLogReceptionDataReceived(EventDetails eventDetails) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$org$jahia$sqlprofiler$gui$LogReceptionListener == null ? LoggingReceiver.class$("org.jahia.sqlprofiler.gui.LogReceptionListener") : class$org$jahia$sqlprofiler$gui$LogReceptionListener)) {
                ((LogReceptionListener)listeners[i + 1]).logReceptionDataReceived(new LogReceptionEvent(this, eventDetails));
            }
            i -= 2;
        }
    }

    LoggingReceiver(LoggerTableModel aModel, int aPort) throws IOException {
        this.setDaemon(true);
        this.mSvrSock = new ServerSocket(aPort);
    }

    public void run() {
        LOG.info("Thread started");
        try {
            while (true) {
                LOG.debug("Waiting for a connection");
                Socket client = this.mSvrSock.accept();
                LOG.debug("Got a connection from " + client.getInetAddress().getHostName());
                Thread t = new Thread(new Slurper(client));
                t.setDaemon(true);
                t.start();
            }
        }
        catch (IOException e) {
            LOG.error("Error in accepting connections, stopping.", e);
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Slurper
    implements Runnable {
        private final Socket mClient;

        Slurper(Socket aClient) {
            this.mClient = aClient;
        }

        public void run() {
            LOG.debug("Starting to get data");
            LoggingReceiver.this.fireLogReceptionConnected();
            try {
                ObjectInputStream ois = new ObjectInputStream(this.mClient.getInputStream());
                while (true) {
                    LoggingEvent event = (LoggingEvent)ois.readObject();
                    LoggingReceiver.this.fireLogReceptionDataReceived(new EventDetails(event));
                }
            }
            catch (EOFException e) {
                LOG.info("Reached EOF, closing connection");
            }
            catch (SocketException e) {
                LOG.info("Caught SocketException, closing connection");
            }
            catch (IOException e) {
                LOG.warn("Got IOException, closing connection", e);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Got ClassNotFoundException, closing connection", e);
            }
            try {
                this.mClient.close();
            }
            catch (IOException e) {
                LOG.warn("Error closing connection", e);
            }
            LoggingReceiver.this.fireLogReceptionDisconnected();
        }
    }
}

