/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.sqlprofiler.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.log4j.Category;
import org.apache.log4j.PropertyConfigurator;
import org.jahia.sqlprofiler.gui.ChartPanel;
import org.jahia.sqlprofiler.gui.ControlPanel;
import org.jahia.sqlprofiler.gui.DetailPanel;
import org.jahia.sqlprofiler.gui.ExitAction;
import org.jahia.sqlprofiler.gui.LogReceptionAdapter;
import org.jahia.sqlprofiler.gui.LogReceptionEvent;
import org.jahia.sqlprofiler.gui.LoggerTableModel;
import org.jahia.sqlprofiler.gui.LoggingReceiver;
import org.jahia.sqlprofiler.gui.MainTabbedPanel;
import org.jahia.sqlprofiler.gui.ProfileDetailsPanel;
import org.jahia.sqlprofiler.gui.ProfileResultTableModel;
import org.jahia.sqlprofiler.gui.ProfileStatementTableModel;
import org.jahia.sqlprofiler.gui.QueryCountChartModel;
import org.jahia.sqlprofiler.gui.QueryTrafficChartModel;
import org.jahia.sqlprofiler.gui.StatusLabel;
import org.jahia.sqlprofiler.gui.ToolbarPanel;

public class Main
extends JFrame {
    private static final int DEFAULT_PORT = 4445;
    public static final String PORT_PROP_NAME = "chainsaw.port";
    private static final Category LOG = Category.getInstance(class$org$jahia$sqlprofiler$gui$Main == null ? (class$org$jahia$sqlprofiler$gui$Main = Main.class$("org.jahia.sqlprofiler.gui.Main")) : class$org$jahia$sqlprofiler$gui$Main);
    static /* synthetic */ Class class$org$jahia$sqlprofiler$gui$Main;

    private Main() {
        super("SQL Profiler v0.3");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException ulafe) {
            LOG.error("Unsupported look & feel : ", ulafe);
        }
        catch (IllegalAccessException iae) {
            LOG.error("Illegal access exception : ", iae);
        }
        catch (InstantiationException ie) {
            LOG.error("Error : ", ie);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error("Error : ", cnfe);
        }
        LoggerTableModel loggerModel = new LoggerTableModel();
        ProfileStatementTableModel profileStatementTableModel = new ProfileStatementTableModel(loggerModel);
        loggerModel.setProfileStatementModel(profileStatementTableModel);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        menu.add(exitMenuItem);
        exitMenuItem.addActionListener(ExitAction.INSTANCE);
        MainTabbedPanel mainTabbedPanel = new MainTabbedPanel();
        JPanel loggerPanel = new JPanel(new BorderLayout());
        JPanel profilerPanel = new JPanel(new BorderLayout());
        JPanel analysisPanel = new JPanel(new BorderLayout());
        ToolbarPanel toolbarPanel = new ToolbarPanel(loggerModel, profileStatementTableModel);
        this.getContentPane().add((Component)toolbarPanel, "North");
        this.buildLoggerPanel(loggerModel, loggerPanel);
        this.buildProfilePanel(profileStatementTableModel, profilerPanel);
        this.buildAnalysisPanel(loggerModel, profileStatementTableModel, analysisPanel);
        mainTabbedPanel.addTab("Profiler", profilerPanel, "SQL Profiler");
        mainTabbedPanel.addTab("Logger", loggerPanel, "Logging view");
        mainTabbedPanel.addTab("Analysis", analysisPanel, "Analysis view");
        mainTabbedPanel.finishTabs();
        this.getContentPane().add((Component)mainTabbedPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent aEvent) {
                ExitAction.INSTANCE.actionPerformed(null);
            }
        });
        Box statusBar = Box.createHorizontalBox();
        JPanel messagePanel = new JPanel(new FlowLayout(0, 0, 0));
        messagePanel.setBorder(BorderFactory.createLoweredBevelBorder());
        JLabel messageTextLabel = new JLabel();
        messageTextLabel.setHorizontalAlignment(2);
        messageTextLabel.setText("Not connected to P6Spy");
        messagePanel.add(messageTextLabel);
        statusBar.add(messagePanel);
        Box statusLabelBox = Box.createHorizontalBox();
        StatusLabel statusLabel = new StatusLabel();
        statusLabelBox.add(statusLabel);
        statusBar.add(statusLabelBox);
        this.getContentPane().add((Component)statusBar, "South");
        this.pack();
        this.setVisible(true);
        this.setupReceiver(loggerModel, statusLabel, messageTextLabel);
    }

    private void buildProfilePanel(ProfileStatementTableModel profileStatementTableModel, JPanel profilerPanel) {
        JTable profileStatementTable = new JTable(profileStatementTableModel);
        profileStatementTableModel.addMouseListenerToHeaderInTable(profileStatementTable);
        profileStatementTable.setSelectionMode(0);
        profileStatementTable.getColumnModel().getColumn(0).setMinWidth(120);
        profileStatementTable.getColumnModel().getColumn(1).setMaxWidth(70);
        profileStatementTable.getColumnModel().getColumn(2).setMaxWidth(30);
        profileStatementTable.getColumnModel().getColumn(3).setPreferredWidth(70);
        profileStatementTable.getColumnModel().getColumn(4).setPreferredWidth(70);
        profileStatementTable.getColumnModel().getColumn(5).setPreferredWidth(290);
        JScrollPane profileScrollPane = new JScrollPane(profileStatementTable);
        profileScrollPane.setBorder(BorderFactory.createTitledBorder("SQL Statements: "));
        profileScrollPane.setPreferredSize(new Dimension(700, 150));
        ProfileResultTableModel profileResultModel = new ProfileResultTableModel();
        profileStatementTableModel.setProfileResultModel(profileResultModel);
        JTable profileResultTable = new JTable(profileResultModel);
        profileResultModel.addMouseListenerToHeaderInTable(profileResultTable);
        profileResultTable.setSelectionMode(0);
        profileResultTable.getColumnModel().getColumn(0).setMaxWidth(50);
        profileResultTable.getColumnModel().getColumn(1).setMaxWidth(70);
        profileResultTable.getColumnModel().getColumn(2).setMaxWidth(70);
        profileResultTable.getColumnModel().getColumn(3).setPreferredWidth(160);
        profileResultTable.getColumnModel().getColumn(4).setPreferredWidth(330);
        JScrollPane profileResultScrollPane = new JScrollPane(profileResultTable);
        profileResultScrollPane.setBorder(BorderFactory.createTitledBorder("Profile results: "));
        profileResultScrollPane.setPreferredSize(new Dimension(700, 150));
        Box counterBox = Box.createHorizontalBox();
        JLabel statementCountTextLabel = new JLabel(" Total statements : ");
        counterBox.add(statementCountTextLabel);
        JLabel statementCountValueLabel = new JLabel("0");
        profileStatementTableModel.setStatementCountValueLabel(statementCountValueLabel);
        counterBox.add(statementCountValueLabel);
        counterBox.add(Box.createHorizontalStrut(10));
        JLabel statementTimeTextLabel = new JLabel(" Total statement time [ms] : ");
        counterBox.add(statementTimeTextLabel);
        JLabel statementTimeValueLabel = new JLabel("0");
        profileStatementTableModel.setStatementTimeValueLabel(statementTimeValueLabel);
        counterBox.add(statementTimeValueLabel);
        profilerPanel.add((Component)counterBox, "North");
        ProfileDetailsPanel profileDetails = new ProfileDetailsPanel(profileStatementTable, profileStatementTableModel);
        profileDetails.setPreferredSize(new Dimension(700, 150));
        JSplitPane profileSplitPane = new JSplitPane(0, profileScrollPane, profileResultScrollPane);
        JSplitPane profileSplitPane2 = new JSplitPane(0, profileSplitPane, profileDetails);
        profilerPanel.add((Component)profileSplitPane2, "Center");
    }

    private void buildLoggerPanel(LoggerTableModel loggerModel, JPanel loggerPanel) {
        ControlPanel cp = new ControlPanel(loggerModel);
        loggerPanel.add((Component)cp, "North");
        JTable loggerTable = new JTable(loggerModel);
        loggerTable.setSelectionMode(0);
        JScrollPane loggerScrollPane = new JScrollPane(loggerTable);
        loggerScrollPane.setBorder(BorderFactory.createTitledBorder("Events: "));
        loggerScrollPane.setPreferredSize(new Dimension(700, 150));
        DetailPanel loggerDetails = new DetailPanel(loggerTable, loggerModel);
        loggerDetails.setPreferredSize(new Dimension(700, 150));
        JSplitPane loggerSplitPane = new JSplitPane(0, loggerScrollPane, loggerDetails);
        loggerPanel.add((Component)loggerSplitPane, "Center");
    }

    private void buildAnalysisPanel(LoggerTableModel loggerModel, ProfileStatementTableModel profileStatementModel, JPanel analysisPanel) {
        try {
            QueryCountChartModel queryCountChartModel = new QueryCountChartModel(profileStatementModel);
            ChartPanel queryCountChartPanel = new ChartPanel(queryCountChartModel);
            loggerModel.setQueryCountChartModel(queryCountChartModel);
            queryCountChartPanel.setPreferredSize(new Dimension(700, 150));
            QueryTrafficChartModel queryTrafficChartModel = new QueryTrafficChartModel(profileStatementModel);
            ChartPanel queryTrafficChartPanel = new ChartPanel(queryTrafficChartModel);
            loggerModel.setQueryTrafficChartModel(queryTrafficChartModel);
            queryTrafficChartPanel.setPreferredSize(new Dimension(700, 150));
            JSplitPane analysisSplitPane = new JSplitPane(0, queryCountChartPanel, queryTrafficChartPanel);
            analysisPanel.add((Component)analysisSplitPane, "Center");
        }
        catch (Throwable t) {
            LOG.error("Error while creating chart panel", t);
        }
    }

    private void setupReceiver(final LoggerTableModel aModel, final StatusLabel statusLabel, final JLabel messageTextLabel) {
        int port = 4445;
        String strRep = System.getProperty(PORT_PROP_NAME);
        if (strRep != null) {
            try {
                port = Integer.parseInt(strRep);
            }
            catch (NumberFormatException nfe) {
                LOG.fatal("Unable to parse chainsaw.port property with value " + strRep + ".");
                JOptionPane.showMessageDialog(this, "Unable to parse port number from '" + strRep + "', quitting.", "CHAINSAW", 0);
                System.exit(1);
            }
        }
        try {
            LoggingReceiver lr = new LoggingReceiver(aModel, port);
            lr.addLogReceptionListener(new LogReceptionAdapter(){

                public void logReceptionConnected(LogReceptionEvent logReceptionEvent) {
                    statusLabel.setStatusActivated(true);
                    messageTextLabel.setText("Connected to P6Spy");
                }

                public void logReceptionDisconnected(LogReceptionEvent logReceptionEvent) {
                    statusLabel.setStatusActivated(false);
                    messageTextLabel.setText("Disconnected from P6Spy");
                }

                public void logReceptionDataReceived(LogReceptionEvent logReceptionEvent) {
                    aModel.addEvent(logReceptionEvent.getEventDetails());
                }
            });
            lr.start();
        }
        catch (IOException e) {
            LOG.fatal("Unable to connect to socket server, quiting", e);
            JOptionPane.showMessageDialog(this, "Unable to create socket on port " + port + ", quitting.", "CHAINSAW", 0);
            System.exit(1);
        }
    }

    private static void initLog4J() {
        Properties props = new Properties();
        props.setProperty("log4j.rootCategory", "DEBUG, A1");
        props.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        props.setProperty("log4j.appender.A1.layout", "org.apache.log4j.TTCCLayout");
        PropertyConfigurator.configure(props);
    }

    public static void main(String[] aArgs) {
        Main.initLog4J();
        new Main();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

