/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.sqlprofiler.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.Iterator;
import java.util.SortedSet;
import org.jCharts.Chart;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.AxisChartDataSet;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.chartData.DataSeries;
import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.properties.LineChartProperties;
import org.jCharts.types.ChartType;
import org.jahia.sqlprofiler.QueryEntry;
import org.jahia.sqlprofiler.gui.AbstractChartModel;
import org.jahia.sqlprofiler.gui.ProfileStatementTableModel;

public class QueryCountChartModel
extends AbstractChartModel {
    private ProfileStatementTableModel profileStatementModel;
    private int statementCount = 0;
    private int resultSetCount = 0;
    private int selectStatementCount = 0;
    private int lastQueryTotal = 0;
    private LineChartProperties lineChartProperties;
    private ChartProperties chartProperties = new ChartProperties();
    private AxisProperties axisProperties = new AxisProperties();
    private LegendProperties legendProperties = new LegendProperties();
    private DataSeries dataSeries = null;

    public QueryCountChartModel(ProfileStatementTableModel profileStatementModel) {
        this.profileStatementModel = profileStatementModel;
        Stroke[] strokes = new Stroke[]{LineChartProperties.DEFAULT_LINE_STROKE, LineChartProperties.DEFAULT_LINE_STROKE, LineChartProperties.DEFAULT_LINE_STROKE, LineChartProperties.DEFAULT_LINE_STROKE};
        Shape[] shapes = new Shape[]{null, null, null, null};
        this.lineChartProperties = new LineChartProperties(strokes, shapes);
    }

    public Chart getChart(Dimension dimension) {
        if (this.dataSeries == null) {
            return null;
        }
        AxisChart axisChart = new AxisChart(this.dataSeries, this.chartProperties, this.axisProperties, this.legendProperties, (int)dimension.getWidth(), (int)dimension.getHeight());
        return axisChart;
    }

    public void update() {
        if (this.profileStatementModel.getQueryEntries().size() == this.lastQueryTotal) {
            return;
        }
        this.lastQueryTotal = this.profileStatementModel.getQueryEntries().size();
        try {
            long lowestTime = this.profileStatementModel.getLowestQueryTime();
            long highestTime = this.profileStatementModel.getHighestQueryTime();
            if (lowestTime != Long.MAX_VALUE && highestTime != Long.MIN_VALUE) {
                double timeInterval = highestTime - lowestTime;
                double timeIncrement = 1000.0;
                double sliceCount = timeInterval / timeIncrement;
                int slices = new Double(sliceCount).intValue();
                if (slices < 2) {
                    return;
                }
                String[] xAxisLabels = new String[slices];
                double[][] data = new double[4][slices];
                int curSlice = 0;
                this.statementCount = 0;
                this.resultSetCount = 0;
                this.selectStatementCount = 0;
                int queriesInSlice = 0;
                SortedSet sortedQueryEntries = this.profileStatementModel.getSortedQueryEntries();
                Iterator queryIter = sortedQueryEntries.iterator();
                double curSampleStartTime = lowestTime;
                double curSampleEndTime = (double)lowestTime + timeIncrement;
                while (queryIter.hasNext()) {
                    QueryEntry curEntry = (QueryEntry)queryIter.next();
                    while ((double)curEntry.getTime() > curSampleEndTime) {
                        xAxisLabels[curSlice] = Long.toString(new Double(curSampleStartTime - (double)lowestTime).longValue());
                        data[0][curSlice] = queriesInSlice;
                        data[1][curSlice] = this.statementCount;
                        data[2][curSlice] = this.resultSetCount;
                        data[3][curSlice] = this.selectStatementCount;
                        this.statementCount = 0;
                        this.resultSetCount = 0;
                        this.selectStatementCount = 0;
                        queriesInSlice = 0;
                        curSampleStartTime = (double)lowestTime + timeIncrement * (double)(++curSlice);
                        curSampleEndTime = (double)lowestTime + timeIncrement * ((double)curSlice + 1.0);
                    }
                    ++queriesInSlice;
                    if (curEntry.getCategory() == null) continue;
                    if (curEntry.getCategory().toLowerCase().equals("statement")) {
                        ++this.statementCount;
                        if (!curEntry.getSqlStatement().toLowerCase().startsWith("select")) continue;
                        ++this.selectStatementCount;
                        continue;
                    }
                    if (!curEntry.getCategory().toLowerCase().equals("resultset")) continue;
                    ++this.resultSetCount;
                }
                String xAxisTitle = "Milliseconds";
                String yAxisTitle = "Queries";
                String title = "Queries over time";
                this.dataSeries = new DataSeries(xAxisLabels, xAxisTitle, yAxisTitle, title);
                String[] legendLabels = new String[]{"Queries / second", "Statements / second", "Result sets / second", "SELECT statements / second"};
                Paint[] paints = new Paint[]{Color.blue, Color.red, Color.cyan, Color.yellow};
                AxisChartDataSet axisChartDataSet = new AxisChartDataSet(data, legendLabels, paints, ChartType.LINE, this.lineChartProperties);
                this.dataSeries.addIAxisPlotDataSet(axisChartDataSet);
                this.fireChartDataChanged();
            }
        }
        catch (ChartDataException chartDataException) {
            chartDataException.printStackTrace();
        }
    }
}

