/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.util.ValueStack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.components.ComboBox;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

@StrutsTag(name="autocompleter", tldTagClass="org.apache.struts2.views.jsp.ui.AutocompleterTag", description="Renders a combobox with autocomplete and AJAX capabilities")
public class Autocompleter
extends ComboBox {
    public static final String TEMPLATE = "autocompleter";
    private static final String COMPONENT_NAME = Autocompleter.class.getName();
    protected String forceValidOption;
    protected String searchType;
    protected String autoComplete;
    protected String delay;
    protected String disabled;
    protected String href;
    protected String dropdownWidth;
    protected String dropdownHeight;
    protected String formId;
    protected String formFilter;
    protected String listenTopics;
    protected String notifyTopics;
    protected String indicator;
    protected String loadOnTextChange;
    protected String loadMinimumCount;
    protected String showDownArrow;
    protected String templateCssPath;
    protected String iconPath;
    protected String keyName;

    public Autocompleter(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    protected String getDefaultTemplate() {
        return TEMPLATE;
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public void evaluateExtraParams() {
        String type;
        super.evaluateExtraParams();
        if (this.forceValidOption != null) {
            this.addParameter("forceValidOption", this.findValue(this.forceValidOption, Boolean.class));
        }
        if (this.searchType != null && (type = this.findString(this.searchType)) != null) {
            this.addParameter("searchType", type.toUpperCase());
        }
        if (this.autoComplete != null) {
            this.addParameter("autoComplete", this.findValue(this.autoComplete, Boolean.class));
        }
        if (this.delay != null) {
            this.addParameter("delay", this.findValue(this.delay, Integer.class));
        }
        if (this.disabled != null) {
            this.addParameter("disabled", this.findValue(this.disabled, Boolean.class));
        }
        if (this.href != null) {
            this.addParameter("href", this.findString(this.href));
            this.addParameter("mode", "remote");
        }
        if (this.dropdownHeight != null) {
            this.addParameter("dropdownHeight", this.findValue(this.dropdownHeight, Integer.class));
        }
        if (this.dropdownWidth != null) {
            this.addParameter("dropdownWidth", this.findValue(this.dropdownWidth, Integer.class));
        }
        if (this.formFilter != null) {
            this.addParameter("formFilter", this.findString(this.formFilter));
        }
        if (this.formId != null) {
            this.addParameter("formId", this.findString(this.formId));
        }
        if (this.listenTopics != null) {
            this.addParameter("listenTopics", this.findString(this.listenTopics));
        }
        if (this.notifyTopics != null) {
            this.addParameter("notifyTopics", this.findString(this.notifyTopics));
        }
        if (this.indicator != null) {
            this.addParameter("indicator", this.findString(this.indicator));
        }
        if (this.loadOnTextChange != null) {
            this.addParameter("loadOnTextChange", this.findValue(this.loadOnTextChange, Boolean.class));
        }
        if (this.loadMinimumCount != null) {
            this.addParameter("loadMinimumCount", this.findValue(this.loadMinimumCount, Integer.class));
        }
        if (this.showDownArrow != null) {
            this.addParameter("showDownArrow", this.findValue(this.showDownArrow, Boolean.class));
        } else {
            this.addParameter("showDownArrow", Boolean.TRUE);
        }
        if (this.templateCssPath != null) {
            this.addParameter("templateCssPath", this.findString(this.templateCssPath));
        }
        if (this.iconPath != null) {
            this.addParameter("iconPath", this.findString(this.iconPath));
        }
        if (this.keyName != null) {
            this.addParameter("keyName", this.findString(this.keyName));
        } else {
            this.keyName = this.name + "Key";
            this.addParameter("keyName", this.findString(this.keyName));
        }
        String keyNameExpr = "%{" + this.keyName + "}";
        this.addParameter("key", this.findString(keyNameExpr));
    }

    protected Object findListValue() {
        return this.list != null ? this.findValue(this.list, Object.class) : null;
    }

    @StrutsTagAttribute(description="Whether autocompleter should make suggestion on the textbox", type="Boolean", defaultValue="false")
    public void setAutoComplete(String autoComplete) {
        this.autoComplete = autoComplete;
    }

    @StrutsTagAttribute(description="Enable or disable autocompleter", type="Boolean", defaultValue="false")
    public void setDisabled(String disabled) {
        this.disabled = disabled;
    }

    @StrutsTagAttribute(description="Force selection to be one of the options", type="Boolean", defaultValue="false")
    public void setForceValidOption(String forceValidOption) {
        this.forceValidOption = forceValidOption;
    }

    @StrutsTagAttribute(description="The URL used to load the options")
    public void setHref(String href) {
        this.href = href;
    }

    @StrutsTagAttribute(description="Delay before making the search", type="Integer", defaultValue="100")
    public void setDelay(String searchDelay) {
        this.delay = searchDelay;
    }

    @StrutsTagAttribute(description="how the search must be performed, options are: 'startstring', 'startword' and 'substring'", defaultValue="stringstart")
    public void setSearchType(String searchType) {
        this.searchType = searchType;
    }

    @StrutsTagAttribute(description="Dropdown's height in pixels", type="Integer", defaultValue="120")
    public void setDropdownHeight(String height) {
        this.dropdownHeight = height;
    }

    @StrutsTagAttribute(description="Dropdown's width", type="Integer", defaultValue="same as textbox")
    public void setDropdownWidth(String width) {
        this.dropdownWidth = width;
    }

    @StrutsTagAttribute(description="Function name used to filter the fields of the form")
    public void setFormFilter(String formFilter) {
        this.formFilter = formFilter;
    }

    @StrutsTagAttribute(description="Form id whose fields will be serialized and passed as parameters")
    public void setFormId(String formId) {
        this.formId = formId;
    }

    @StrutsTagAttribute(description="Topic that will trigger a reload")
    public void setListenTopics(String listenTopics) {
        this.listenTopics = listenTopics;
    }

    @StrutsTagAttribute(description="Topics that will be published when content is reloaded")
    public void setNotifyTopics(String onValueChangedPublishTopic) {
        this.notifyTopics = onValueChangedPublishTopic;
    }

    @StrutsTagAttribute(description="Id of element that will be shown while request is made")
    public void setIndicator(String indicator) {
        this.indicator = indicator;
    }

    @StrutsTagAttribute(description="Minimum number of characters that will force the content to be loaded", type="Integer", defaultValue="3")
    public void setLoadMinimumCount(String loadMinimumCount) {
        this.loadMinimumCount = loadMinimumCount;
    }

    @StrutsTagAttribute(description="Options will be reloaded everytime a character is typed on the textbox", type="Boolean", defaultValue="true")
    public void setLoadOnTextChange(String loadOnType) {
        this.loadOnTextChange = loadOnType;
    }

    @StrutsTagAttribute(description="Show or hide the down arrow button", type="Boolean", defaultValue="true")
    public void setShowDownArrow(String showDownArrow) {
        this.showDownArrow = showDownArrow;
    }

    @StrutsTagAttribute(description="Iteratable source to populate from.")
    public void setList(String list) {
        super.setList(list);
    }

    @StrutsTagAttribute(description="Template css path")
    public void setTemplateCssPath(String templateCssPath) {
        this.templateCssPath = templateCssPath;
    }

    @StrutsTagAttribute(description="Path to icon used for the dropdown")
    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    @StrutsTagAttribute(description="Name of the field to which the selected key will be assigned")
    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }
}

