/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.TextProviderSupport;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.Writer;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.struts2.StrutsException;
import org.apache.struts2.components.Component;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

@StrutsTag(name="i18n", tldTagClass="org.apache.struts2.views.jsp.I18nTag", description="Get a resource bundle and place it on the value stack")
public class I18n
extends Component {
    protected boolean pushed;
    protected String name;

    public I18n(ValueStack stack) {
        super(stack);
    }

    public boolean start(Writer writer) {
        boolean result = super.start(writer);
        try {
            String name = this.findString(this.name, "name", "Resource bundle name is required. Example: foo or foo_en");
            ResourceBundle bundle = (ResourceBundle)this.findValue("texts('" + name + "')");
            if (bundle == null) {
                bundle = LocalizedTextUtil.findResourceBundle((String)name, (Locale)((Locale)this.getStack().getContext().get("com.opensymphony.xwork2.ActionContext.locale")));
            }
            if (bundle != null) {
                final Locale locale = (Locale)this.getStack().getContext().get("com.opensymphony.xwork2.ActionContext.locale");
                this.getStack().push((Object)new TextProviderSupport(bundle, new LocaleProvider(){

                    public Locale getLocale() {
                        return locale;
                    }
                }));
                this.pushed = true;
            }
        }
        catch (Exception e) {
            String msg = "Could not find the bundle " + this.name;
            throw new StrutsException(msg, e);
        }
        return result;
    }

    public boolean end(Writer writer, String body) {
        if (this.pushed) {
            this.getStack().pop();
        }
        return super.end(writer, body);
    }

    @StrutsTagAttribute(description="Name of ressource bundle to use (eg foo/bar/customBundle)", required=true, defaultValue="String")
    public void setName(String name) {
        this.name = name;
    }
}

