/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.util.ValueStack;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.components.Component;
import org.apache.struts2.components.Param;
import org.apache.struts2.util.MakeIterator;
import org.apache.struts2.util.MergeIteratorFilter;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

@StrutsTag(name="merge", tldTagClass="org.apache.struts2.views.jsp.iterator.MergeIteratorTag", description="Merge the values of a list of iterators into one iterator")
public class MergeIterator
extends Component
implements Param.UnnamedParametric {
    private static final Log _log = LogFactory.getLog(MergeIterator.class);
    private MergeIteratorFilter mergeIteratorFilter = null;
    private List _parameters;

    public MergeIterator(ValueStack stack) {
        super(stack);
    }

    public boolean start(Writer writer) {
        this.mergeIteratorFilter = new MergeIteratorFilter();
        this._parameters = new ArrayList();
        return super.start(writer);
    }

    public boolean end(Writer writer, String body) {
        for (Object iteratorEntryObj : this._parameters) {
            if (!MakeIterator.isIterable(iteratorEntryObj)) {
                _log.warn((Object)("param with value resolved as " + iteratorEntryObj + " cannot be make as iterator, it will be ignored and hence will not appear in the merged iterator"));
                continue;
            }
            this.mergeIteratorFilter.setSource(MakeIterator.convert(iteratorEntryObj));
        }
        this.mergeIteratorFilter.execute();
        if (this.getId() != null && this.getId().length() > 0) {
            this.getStack().getContext().put(this.getId(), this.mergeIteratorFilter);
        }
        this.mergeIteratorFilter = null;
        return super.end(writer, body);
    }

    @StrutsTagAttribute(description="The id where the resultant merged iterator will be stored in the stack's context")
    public void setId(String id) {
        super.setId(id);
    }

    public void addParameter(Object value) {
        this._parameters.add(value);
    }
}

