/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.util.ValueStack;
import java.io.Writer;
import org.apache.struts2.components.Component;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

@StrutsTag(name="set", tldBodyContent="empty", tldTagClass="org.apache.struts2.views.jsp.SetTag", description="Assigns a value to a variable in a specified scope")
public class Set
extends Component {
    protected String name;
    protected String scope;
    protected String value;

    public Set(ValueStack stack) {
        super(stack);
    }

    public boolean end(Writer writer, String body) {
        String name;
        ValueStack stack = this.getStack();
        if (this.value == null) {
            this.value = "top";
        }
        Object o = this.findValue(this.value);
        if (this.altSyntax()) {
            name = this.findString(this.name, "name", "Name is required");
        } else {
            name = this.name;
            if (this.name == null) {
                throw this.fieldError("name", "Name is required", null);
            }
        }
        if ("application".equalsIgnoreCase(this.scope)) {
            stack.setValue("#application['" + name + "']", o);
        } else if ("session".equalsIgnoreCase(this.scope)) {
            stack.setValue("#session['" + name + "']", o);
        } else if ("request".equalsIgnoreCase(this.scope)) {
            stack.setValue("#request['" + name + "']", o);
        } else if ("page".equalsIgnoreCase(this.scope)) {
            stack.setValue("#attr['" + name + "']", o, false);
        } else {
            stack.getContext().put(name, o);
            stack.setValue("#attr['" + name + "']", o, false);
        }
        return super.end(writer, body);
    }

    @StrutsTagAttribute(description=" The name of the new variable that is assigned the value of <i>value</i>", required=true)
    public void setName(String name) {
        this.name = name;
    }

    @StrutsTagAttribute(description="The scope in which to assign the variable. Can be <b>application</b>, <b>session</b>, <b>request</b>, <b>page</b>, or <b>action</b>.", defaultValue="action")
    public void setScope(String scope) {
        this.scope = scope;
    }

    @StrutsTagAttribute(description="The value that is assigned to the variable named <i>name</i>")
    public void setValue(String value) {
        this.value = value;
    }
}

