/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.struts2.dispatcher.ServletRedirectResult;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.views.util.UrlHelper;

public class ServletActionRedirectResult
extends ServletRedirectResult {
    private static final long serialVersionUID = -9042425229314584066L;
    public static final String DEFAULT_PARAM = "actionName";
    protected String actionName;
    protected String namespace;
    protected String method;
    private Map<String, String> requestParameters = new HashMap<String, String>();
    protected List<String> prohibitedResultParam = Arrays.asList("actionName", "namespace", "method", "encode", "parse", "location", "prependServletContext");

    public ServletActionRedirectResult() {
    }

    public ServletActionRedirectResult(String actionName) {
        this(null, actionName, null);
    }

    public ServletActionRedirectResult(String actionName, String method) {
        this(null, actionName, method);
    }

    public ServletActionRedirectResult(String namespace, String actionName, String method) {
        super(null);
        this.namespace = namespace;
        this.actionName = actionName;
        this.method = method;
    }

    public void execute(ActionInvocation invocation) throws Exception {
        this.actionName = this.conditionalParse(this.actionName, invocation);
        this.namespace = this.namespace == null ? invocation.getProxy().getNamespace() : this.conditionalParse(this.namespace, invocation);
        this.method = this.method == null ? "" : this.conditionalParse(this.method, invocation);
        String resultCode = invocation.getResultCode();
        if (resultCode != null) {
            ResultConfig resultConfig = (ResultConfig)invocation.getProxy().getConfig().getResults().get(resultCode);
            Map resultConfigParams = resultConfig.getParams();
            for (Map.Entry e : resultConfigParams.entrySet()) {
                if (this.prohibitedResultParam.contains(e.getKey())) continue;
                this.requestParameters.put(e.getKey().toString(), e.getValue() == null ? "" : this.conditionalParse(e.getValue().toString(), invocation));
            }
        }
        StringBuffer tmpLocation = new StringBuffer(this.actionMapper.getUriFromActionMapping(new ActionMapping(this.actionName, this.namespace, this.method, null)));
        UrlHelper.buildParametersString(this.requestParameters, tmpLocation, "&");
        this.setLocation(tmpLocation.toString());
        super.execute(invocation);
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public ServletActionRedirectResult addParameter(String key, Object value) {
        this.requestParameters.put(key, String.valueOf(value));
        return this;
    }
}

