/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.common.datatype;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class PageRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int count;
    private int pageNo;
    private int pageCount = 1;
    private int rowsPerPage = 10;
    private int totalPageCount = -1;
    private Collection result = new ArrayList();

    public int getCount() {
        return this.count;
    }

    public Collection getResult() {
        return this.result;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public PageRecord(int count, Collection result) {
        this.count = count;
        this.result = result;
        if (this.result == null) {
            this.result = new ArrayList();
        }
    }

    public PageRecord(int count, int pageNo, Collection result) {
        this(count, pageNo, 1, result);
    }

    public PageRecord(int count, int pageNo, int pageCount, Collection result) {
        this(count, pageNo, pageCount, 10, result);
    }

    public PageRecord(int count, int pageNo, int pageCount, int rowsPerPage, Collection result) {
        this.count = count;
        this.pageNo = pageNo;
        this.pageCount = pageCount;
        this.result = result;
        this.rowsPerPage = rowsPerPage;
        if (this.result == null) {
            this.result = new ArrayList();
        }
        if (rowsPerPage <= 0) {
            rowsPerPage = 10;
        }
        this.totalPageCount = count / rowsPerPage;
        if (count - count / rowsPerPage * rowsPerPage > 0) {
            ++this.totalPageCount;
        }
    }

    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    public int getTotalPageCount() {
        return this.totalPageCount;
    }
}

