/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.common.util;

import com.sinosoft.sysframework.common.datatype.DateTime;
import com.sinosoft.sysframework.common.util.ObjectUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataUtils {
    private static Log logger = LogFactory.getLog((Class)(class$com$sinosoft$sysframework$common$util$DataUtils == null ? (class$com$sinosoft$sysframework$common$util$DataUtils = DataUtils.class$("com.sinosoft.sysframework.common.util.DataUtils")) : class$com$sinosoft$sysframework$common$util$DataUtils));
    private static final BigDecimal ONE = new BigDecimal("1");
    private static Map supportTypeMap = new HashMap();
    static /* synthetic */ Class class$com$sinosoft$sysframework$common$util$DataUtils;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$sql$Timestamp;

    private DataUtils() {
    }

    public static String zeroToEmpty(int i) {
        return i == 0 ? "" : String.valueOf(i);
    }

    public static String zeroToEmpty(double d) {
        return d == 0.0 ? "" : String.valueOf(d);
    }

    public static String nullToEmpty(String str) {
        return str == null ? "" : str;
    }

    public static String emptyToNull(String str) {
        if (str == null) {
            return null;
        }
        if (str.trim().length() == 0) {
            return null;
        }
        return str;
    }

    public static String dbNullToEmpty(String str) {
        if (str == null || str.equalsIgnoreCase("null")) {
            return "";
        }
        return str;
    }

    public static String nullToZero(String str) {
        if (str == null || str.trim().length() == 0) {
            return "0";
        }
        return str;
    }

    public static String getBooleanDescribe(String str) {
        if (str == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (str.equalsIgnoreCase("y") || str.equalsIgnoreCase("yes") || str.equalsIgnoreCase("true") || str.equalsIgnoreCase("t") || str.equalsIgnoreCase("\u662f") || str.equalsIgnoreCase("1")) {
            return "\u662f";
        }
        if (str.equalsIgnoreCase("n") || str.equalsIgnoreCase("no") || str.equalsIgnoreCase("false") || str.equalsIgnoreCase("f") || str.equalsIgnoreCase("\u5426") || str.equalsIgnoreCase("0")) {
            return "\u5426";
        }
        if (str.trim().equals("")) {
            return "";
        }
        throw new IllegalArgumentException("argument not in ('y','n','yes','no','true','false','t','f','\u662f','\u5426','1','0','')");
    }

    public static boolean getBoolean(String str) {
        if (str == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (str.equalsIgnoreCase("y") || str.equalsIgnoreCase("yes") || str.equalsIgnoreCase("true") || str.equalsIgnoreCase("t") || str.equalsIgnoreCase("\u662f") || str.equalsIgnoreCase("1")) {
            return true;
        }
        if (str.equalsIgnoreCase("n") || str.equalsIgnoreCase("no") || str.equalsIgnoreCase("false") || str.equalsIgnoreCase("f") || str.equalsIgnoreCase("\u5426") || str.equalsIgnoreCase("0")) {
            return false;
        }
        if (str.trim().equals("")) {
            return false;
        }
        throw new IllegalArgumentException("argument not in ('y','n','yes','no','true','false','t','f','\u662f','\u5426','1','0','')");
    }

    public static String getBooleanDescribe(boolean bln) {
        if (bln) {
            return DataUtils.getBooleanDescribe("true");
        }
        return DataUtils.getBooleanDescribe("false");
    }

    public static int compareByValue(String str1, String str2) {
        BigDecimal big1 = new BigDecimal(str1);
        BigDecimal big2 = new BigDecimal(str2);
        return big1.compareTo(big2);
    }

    public static double round(double value, int scale) {
        BigDecimal b = new BigDecimal(Double.toString(value));
        return b.divide(ONE, scale, 4).doubleValue();
    }

    public static void copySimpleObject(Object target, Object source) {
        if (target != null && source != null) {
            Method method;
            List targetMethodList = ObjectUtils.getSetter(target.getClass());
            List sourceMethodList = ObjectUtils.getGetter(source.getClass());
            HashMap<String, Method> map = new HashMap<String, Method>();
            Iterator iter = sourceMethodList.iterator();
            while (iter.hasNext()) {
                method = (Method)iter.next();
                map.put(method.getName(), method);
            }
            iter = targetMethodList.iterator();
            while (iter.hasNext()) {
                method = (Method)iter.next();
                String fieldName = method.getName().substring(3);
                try {
                    Object value;
                    Method sourceMethod = (Method)map.get("get" + fieldName);
                    if (sourceMethod == null) {
                        sourceMethod = (Method)map.get("is" + fieldName);
                    }
                    if (sourceMethod == null || (value = sourceMethod.invoke(source, new Object[0])) == null) continue;
                    method.invoke(target, value);
                }
                catch (Exception e) {
                    System.out.println("===copySimpleObject exception=" + e.getMessage());
                }
            }
        }
    }

    public static void copySimpleObject(Object target, Object source, boolean isCopyNull) {
        Method method;
        if (target == null || source == null) {
            return;
        }
        List targetMethodList = ObjectUtils.getSetter(target.getClass());
        List sourceMethodList = ObjectUtils.getGetter(source.getClass());
        HashMap<String, Method> map = new HashMap<String, Method>();
        Iterator iter = sourceMethodList.iterator();
        while (iter.hasNext()) {
            method = (Method)iter.next();
            map.put(method.getName(), method);
        }
        iter = targetMethodList.iterator();
        while (iter.hasNext()) {
            method = (Method)iter.next();
            String fieldName = method.getName().substring(3);
            try {
                Method sourceMethod = (Method)map.get("get" + fieldName);
                if (sourceMethod == null) {
                    sourceMethod = (Method)map.get("is" + fieldName);
                }
                if (sourceMethod == null || !supportTypeMap.containsKey(sourceMethod.getReturnType())) continue;
                Object value = sourceMethod.invoke(source, new Object[0]);
                if (isCopyNull) {
                    method.invoke(target, value);
                    continue;
                }
                if (value == null) continue;
                method.invoke(target, value);
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)e);
            }
        }
    }

    public static List generateListFromJdbcResult(List jdbcResultList, Class clazz) {
        ArrayList objectList = new ArrayList();
        try {
            List methodList = ObjectUtils.getSetter(clazz);
            for (int i = 0; i < jdbcResultList.size(); ++i) {
                Map rowMap = (Map)jdbcResultList.get(i);
                Object[] rowKeys = rowMap.keySet().toArray();
                Object object = clazz.newInstance();
                block6: for (int j = 0; j < rowKeys.length; ++j) {
                    String column = (String)rowKeys[j];
                    for (int k = 0; k < methodList.size(); ++k) {
                        Method method = (Method)methodList.get(k);
                        String upperMethodName = method.getName().toUpperCase();
                        if (!upperMethodName.equals("SET" + column)) continue;
                        Class<?> type = method.getParameterTypes()[0];
                        Object value = rowMap.get(column);
                        if (value != null) {
                            if (type == (class$java$lang$Integer == null ? DataUtils.class$("java.lang.Integer") : class$java$lang$Integer)) {
                                value = new Integer(value.toString());
                            } else if (type == (class$java$lang$Double == null ? DataUtils.class$("java.lang.Double") : class$java$lang$Double)) {
                                value = new Double(value.toString());
                            } else if (type == (class$java$lang$Long == null ? DataUtils.class$("java.lang.Long") : class$java$lang$Long)) {
                                value = new Long(value.toString());
                            }
                        }
                        method.invoke(object, value);
                        continue block6;
                    }
                }
                objectList.add(object);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        return objectList;
    }

    public static Integer getInteger(Object object) {
        Integer _integer = null;
        if (object != null) {
            _integer = new Integer(object.toString());
        }
        return _integer;
    }

    public static Long getLong(Object object) {
        Long _long = null;
        if (object != null) {
            _long = new Long(object.toString());
        }
        return _long;
    }

    public static Double getDouble(Object object) {
        Double _double = null;
        if (object != null) {
            _double = new Double(object.toString());
        }
        return _double;
    }

    public static DateTime getDateTime(Object object) {
        DateTime dateTime = null;
        if (object != null) {
            dateTime = object.getClass() == (class$java$sql$Date == null ? (class$java$sql$Date = DataUtils.class$("java.sql.Date")) : class$java$sql$Date) ? new DateTime((Date)object, 13) : (object.getClass() == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = DataUtils.class$("java.sql.Timestamp")) : class$java$sql$Timestamp) ? new DateTime((Timestamp)object, 16) : new DateTime((java.util.Date)object));
        }
        return dateTime;
    }

    public static String getString(Object object) {
        String string = null;
        if (object != null) {
            string = object.toString();
        }
        return string;
    }

    public static String getPlainNumber(Integer integer) {
        if (integer == null) {
            return "";
        }
        DecimalFormat df = new DecimalFormat("###0");
        String plainNumber = df.format(integer);
        return plainNumber;
    }

    public static String getPlainNumber(Long _long) {
        if (_long == null) {
            return "";
        }
        DecimalFormat df = new DecimalFormat("###0");
        String plainNumber = df.format(_long);
        return plainNumber;
    }

    public static String getPlainNumber(Double _double) {
        if (_double == null) {
            return "";
        }
        DecimalFormat df = new DecimalFormat("###0.00");
        String plainNumber = df.format(_double);
        return plainNumber;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        supportTypeMap.put(class$java$lang$Integer == null ? (class$java$lang$Integer = DataUtils.class$("java.lang.Integer")) : class$java$lang$Integer, "");
        supportTypeMap.put(class$java$lang$Long == null ? (class$java$lang$Long = DataUtils.class$("java.lang.Long")) : class$java$lang$Long, "");
        supportTypeMap.put(class$java$lang$Double == null ? (class$java$lang$Double = DataUtils.class$("java.lang.Double")) : class$java$lang$Double, "");
        supportTypeMap.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DataUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, "");
        supportTypeMap.put(class$java$lang$String == null ? (class$java$lang$String = DataUtils.class$("java.lang.String")) : class$java$lang$String, "");
        supportTypeMap.put(class$java$sql$Date == null ? (class$java$sql$Date = DataUtils.class$("java.sql.Date")) : class$java$sql$Date, "");
        supportTypeMap.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = DataUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean, "");
        supportTypeMap.put(array$B == null ? (array$B = DataUtils.class$("[B")) : array$B, "");
    }
}

