/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.common.util;

import com.sinosoft.sysframework.common.util.DataUtils;
import java.text.DecimalFormat;

public class MoneyUtils {
    protected static final String DOLLARS = "DOLLARS";
    protected static final String DOLLAR = "DOLLAR";
    protected static final String CENTS = "CENTS";
    protected static final String CENT = "CENT";
    protected static final String BILLION = "BILLION";
    protected static final String MILLION = "MILLION";
    protected static final String THOUSAND = "THOUSAND";
    protected static final String HUNDRED = "HUNDRED";
    protected static final String ZERO = "ZERO";
    protected static final String ONLY = "ONLY";
    protected static final int ONE_BILLION = 1000000000;
    protected static final int ONE_MILLION = 1000000;
    protected static final int ONE_THOUSAND = 1000;

    private MoneyUtils() {
    }

    public static String toChinese(int iFee, String iCurrency) {
        return MoneyUtils.toChinese((double)iFee, iCurrency);
    }

    public static String toChinese(long iFee, String iCurrency) {
        return MoneyUtils.toChinese((double)iFee, iCurrency);
    }

    public static String toChinese(double iFee, String iCurrency) {
        String strChineseMoney = "";
        String strNumber = "              ";
        String strFee = "";
        String strThat = "";
        int intLength = 0;
        int i = 0;
        int j = 0;
        if (iCurrency == null || iCurrency.length() == 0) {
            iCurrency = "CNY";
        }
        if (iFee < 0.0) {
            throw new IllegalArgumentException("\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f");
        }
        if (iFee == 0.0) {
            return strChineseMoney;
        }
        strFee = new DecimalFormat("0").format(iFee * 100.0);
        intLength = strFee.length();
        if (intLength > 14) {
            throw new IllegalArgumentException("\u91d1\u989d\u8d85\u51fa\u8303\u56f4");
        }
        strNumber = strNumber.substring(0, 14 - intLength) + strFee;
        for (i = 14 - intLength; i < 14; ++i) {
            j = new Integer(strNumber.substring(i, i + 1));
            if (j > 0) {
                strChineseMoney = strChineseMoney.trim() + strThat.trim() + MoneyUtils.getUpperChineseDigit(j).trim() + MoneyUtils.getUpperChineseUnit(i, iCurrency);
                strThat = "";
                continue;
            }
            if (strChineseMoney.length() == 0) continue;
            if (i == 11) {
                strChineseMoney = strChineseMoney + MoneyUtils.getUpperChineseUnit(11, iCurrency);
            } else if (i == 7 && !strNumber.substring(4, 8).equals("0000")) {
                strChineseMoney = strChineseMoney + "\u4e07";
            } else if (i == 3 && !strNumber.substring(0, 4).equals("0000")) {
                strChineseMoney = strChineseMoney + "\u4ebf";
            }
            if (i >= 11 && i != 12) continue;
            strThat = MoneyUtils.getUpperChineseDigit(0);
        }
        if (strChineseMoney.endsWith("\u62fe")) {
            strChineseMoney = strChineseMoney + "\u5206";
        }
        if (strChineseMoney.endsWith("\u5706")) {
            strChineseMoney = strChineseMoney + "\u6574";
        }
        if (strChineseMoney.endsWith("\u89d2")) {
            strChineseMoney = strChineseMoney + "\u6574";
        }
        return strChineseMoney;
    }

    public static String getUpperChineseDigit(int iDigit) {
        String strUpperChineseDigit = "";
        String strUpperChineseChar = "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396";
        if (iDigit > 9) {
            throw new IllegalArgumentException("\u91d1\u989d\u8d85\u51fa\u8303\u56f4");
        }
        if (iDigit < 0) {
            throw new IllegalArgumentException("\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f");
        }
        strUpperChineseDigit = strUpperChineseChar.substring(iDigit, iDigit + 1);
        return strUpperChineseDigit;
    }

    private static String getUpperChineseUnit(int iPoint, String iCurrency) {
        String strUpperChineseUnit = "";
        String strUpperChineseUnitChar = "";
        if (iPoint > 13) {
            throw new IllegalArgumentException("\u91d1\u989d\u8d85\u51fa\u8303\u56f4");
        }
        if (iPoint < 0) {
            throw new IllegalArgumentException("\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f");
        }
        strUpperChineseUnitChar = (iCurrency = iCurrency.trim()).equals("CNY") ? "\u4edf\u4f70\u62fe\u4ebf\u4edf\u4f70\u62fe\u4e07\u4edf\u4f70\u62fe\u5706\u89d2\u5206" : (iCurrency.equals("HKD") ? "\u4edf\u4f70\u62fe\u4ebf\u4edf\u4f70\u62fe\u4e07\u4edf\u4f70\u62fe\u5706\u89d2\u5206" : (iCurrency.equals("JPY") ? "\u4edf\u4f70\u62fe\u4ebf\u4edf\u4f70\u62fe\u4e07\u4edf\u4f70\u62fe\u5706\u89d2\u5206" : (iCurrency.equals("GBP") ? "\u4edf\u4f70\u62fe\u4ebf\u4edf\u4f70\u62fe\u4e07\u4edf\u4f70\u62fe\u9551\u5148\u4ee4\u4fbf\u58eb" : "\u4edf\u4f70\u62fe\u4ebf\u4edf\u4f70\u62fe\u4e07\u4edf\u4f70\u62fe\u5706\u62fe\u5206")));
        strUpperChineseUnit = strUpperChineseUnitChar.substring(iPoint, iPoint + 1);
        return strUpperChineseUnit;
    }

    public static String getUpperEnglishDigit(int iFee) {
        String[] strTemp = new String[]{ZERO, "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE", "TEN", "ELEVEN", "TWELVE", "THIRTEEN", "FOURTEEN", "FIFTEEN", "SIXTEEN", "SEVENTEEN", "EIGHTEEN", "NINETEEN", "TWENTY", "THIRTY", "FORTY", "FIFTY", "SIXTY", "SEVENTY", "EIGHTY", "NINETY"};
        if (iFee > 27 || iFee < 0) {
            throw new IllegalArgumentException("Array index overflow!");
        }
        return strTemp[iFee];
    }

    private static double getInt(double iFee, int iLen) {
        String strFee = "";
        int index = 0;
        strFee = new DecimalFormat("0.00").format(iFee);
        index = strFee.indexOf(".");
        strFee = strFee.substring(0, index - iLen);
        return Double.parseDouble(strFee);
    }

    private static double getDecimal(double iFee, int iLen) {
        String strFee = "";
        int index = 0;
        strFee = new DecimalFormat("0.00").format(iFee);
        index = strFee.indexOf(".");
        strFee = strFee.substring(index - iLen);
        return Double.parseDouble(strFee);
    }

    private static String format_99(int iFee) {
        String strOutFee = "";
        int i = 0;
        int j = 0;
        if (iFee > 0 && iFee < 100) {
            if (iFee <= 20) {
                strOutFee = MoneyUtils.getUpperEnglishDigit(iFee);
            } else {
                j = new Double(iFee / 10).intValue();
                strOutFee = MoneyUtils.getUpperEnglishDigit(j + 18);
                i = iFee - 10 * j;
                if (i != 0) {
                    strOutFee = strOutFee + " " + MoneyUtils.getUpperEnglishDigit(i);
                }
            }
        } else {
            strOutFee = "";
        }
        return strOutFee;
    }

    private static String format_999(double iFee) {
        String strOutFee = "";
        int i = 0;
        int j = 0;
        if (iFee >= 0.0 && iFee < 1000.0) {
            i = new Double(iFee / 100.0).intValue();
            j = new Double(iFee).intValue() % 100;
            strOutFee = MoneyUtils.format_99(j);
            if (i != 0) {
                if (strOutFee.length() > 0 && !strOutFee.substring(0, 1).equals(" ")) {
                    strOutFee = " AND " + strOutFee;
                }
                strOutFee = MoneyUtils.getUpperEnglishDigit(i) + " " + HUNDRED + strOutFee;
            }
        } else {
            strOutFee = "";
        }
        return strOutFee;
    }

    private static String formatToEnglish(double iFee) {
        String strOutFee = "";
        String strTmpFee = "";
        if (iFee < 0.0) {
            strOutFee = MoneyUtils.formatToEnglish(-iFee);
            strOutFee = "MINUS " + strOutFee;
            return strOutFee;
        }
        if (iFee < 1.0) {
            strOutFee = ZERO;
            return strOutFee;
        }
        if (iFee >= 1.0E9) {
            strOutFee = MoneyUtils.formatToEnglish(MoneyUtils.getInt(iFee, 9));
            strTmpFee = MoneyUtils.formatToEnglish(MoneyUtils.getDecimal(iFee, 9));
            if (!strTmpFee.equals(ZERO)) {
                strTmpFee = " " + strTmpFee;
            }
            strOutFee = strTmpFee.indexOf(MILLION) > -1 ? strOutFee + " " + BILLION + strTmpFee : strOutFee + " " + BILLION + " AND " + strTmpFee;
        } else if (iFee >= 1000000.0 && iFee < 1.0E9) {
            strOutFee = MoneyUtils.format_999(MoneyUtils.getInt(iFee, 6));
            strTmpFee = MoneyUtils.formatToEnglish(MoneyUtils.getDecimal(iFee, 6));
            if (!strTmpFee.equals(ZERO)) {
                strTmpFee = " " + strTmpFee;
            }
            strOutFee = strTmpFee.indexOf(THOUSAND) > -1 ? strOutFee + " " + MILLION + strTmpFee : strOutFee + " " + MILLION + " AND " + strTmpFee;
        } else if (iFee >= 1000.0 && iFee < 1000000.0) {
            strOutFee = MoneyUtils.format_999(MoneyUtils.getInt(iFee, 3));
            strTmpFee = MoneyUtils.formatToEnglish(MoneyUtils.getDecimal(iFee, 3));
            if (!strTmpFee.equals(ZERO)) {
                strTmpFee = " " + strTmpFee;
            }
            strOutFee = strTmpFee.indexOf(HUNDRED) > -1 ? strOutFee + " " + THOUSAND + strTmpFee : strOutFee + " " + THOUSAND + " AND " + strTmpFee;
        } else if (iFee >= 1.0 && iFee < 1000.0) {
            strOutFee = MoneyUtils.format_999(iFee);
        }
        return strOutFee;
    }

    public static String toEnglish(double iFee) {
        String strOutFee = "";
        String strFee = "";
        String strCent = "";
        String strTmpFee = "";
        int i = 0;
        if (iFee < 0.0) {
            throw new IllegalArgumentException("Money can not be negative!");
        }
        strFee = new DecimalFormat("0").format(iFee * 100.0);
        i = strFee.length();
        if (i > 14) {
            throw new IllegalArgumentException("Money exceeds its range(fourteen digits)!");
        }
        if (iFee == 0.0) {
            strOutFee = ZERO;
        }
        strCent = CENTS;
        strOutFee = MoneyUtils.formatToEnglish(MoneyUtils.getInt(iFee, 0));
        strTmpFee = MoneyUtils.formatToEnglish(DataUtils.round(MoneyUtils.getDecimal(iFee, 0) * 100.0, 0));
        if (strTmpFee.equals(MoneyUtils.getUpperEnglishDigit(1))) {
            strCent = CENT;
        }
        if (!strTmpFee.equals(ZERO)) {
            strOutFee = strOutFee.equals(ZERO) ? strTmpFee + " " + strCent : strOutFee + " AND " + strCent + " " + strTmpFee;
        }
        strOutFee = strOutFee + " ONLY";
        return strOutFee;
    }

    public static String toEnglish(int iFee) {
        return MoneyUtils.toEnglish((double)iFee);
    }

    public static String toEnglish(long iFee) {
        return MoneyUtils.toEnglish((double)iFee);
    }

    public static String toAccount(String strMoney) {
        String formatMoney = "";
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
        formatMoney = decimalFormat.format(DataUtils.round(Double.valueOf(strMoney), 2));
        return formatMoney;
    }
}

