/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.common.util;

import com.sinosoft.sysframework.common.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ParamSqlUtils {
    private static final long serialVersionUID = 1L;
    public static final int LIKE = 1;
    public static final int IN = 2;
    public static final int BETWEEN = 3;
    public static final int EQ = 4;
    public static final int NOTEQ = 5;
    public static final int GT = 6;
    public static final int GE = 7;
    public static final int LT = 8;
    public static final int LE = 9;
    private List ruleList = new ArrayList();

    private ParamSqlUtils() {
    }

    public static ParamSqlUtils getInstance() {
        return new ParamSqlUtils();
    }

    public String comsumeSql() {
        StringBuffer buffer = new StringBuffer(" ");
        block11: for (int i = 0; i < this.ruleList.size(); ++i) {
            Rule rule = (Rule)this.ruleList.get(i);
            if (rule.comsumed) continue;
            rule.setComsumed(true);
            if (buffer.length() > 1) {
                buffer.append("and ");
            }
            switch (rule.getType()) {
                case 4: {
                    buffer.append(rule.getPropertyName()).append(" = ? ");
                    continue block11;
                }
                case 1: {
                    buffer.append(rule.getPropertyName()).append(" like ? ");
                    continue block11;
                }
                case 3: {
                    buffer.append(rule.getPropertyName()).append(" between ? and ? ");
                    continue block11;
                }
                case 5: {
                    buffer.append(rule.getPropertyName()).append(" != ? ");
                    continue block11;
                }
                case 6: {
                    buffer.append(rule.getPropertyName()).append(" > ? ");
                    continue block11;
                }
                case 7: {
                    buffer.append(rule.getPropertyName()).append(" >= ? ");
                    continue block11;
                }
                case 8: {
                    buffer.append(rule.getPropertyName()).append(" < ? ");
                    continue block11;
                }
                case 9: {
                    buffer.append(rule.getPropertyName()).append(" <= ? ");
                    continue block11;
                }
                case 2: {
                    buffer.append(rule.getPropertyName()).append(" in (");
                    int valueCount = rule.getValues().length;
                    for (int j = 0; j < valueCount; ++j) {
                        buffer.append("?");
                        if (j >= valueCount - 1) continue;
                        buffer.append(",");
                    }
                    buffer.append(") ");
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("Unsupport type " + rule.getType());
                }
            }
        }
        buffer.append(" ");
        return buffer.toString();
    }

    public Object[] getValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        block5: for (int i = 0; i < this.ruleList.size(); ++i) {
            Rule rule = (Rule)this.ruleList.get(i);
            switch (rule.getType()) {
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    values.add(rule.getValues()[0]);
                    continue block5;
                }
                case 3: {
                    values.add(rule.getValues()[0]);
                    values.add(rule.getValues()[1]);
                    continue block5;
                }
                case 2: {
                    int valueCount = rule.getValues().length;
                    for (int j = 0; j < valueCount; ++j) {
                        values.add(rule.getValues()[j]);
                    }
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unsupport type " + rule.getType());
                }
            }
        }
        return values.toArray();
    }

    public ParamSqlUtils addEqual(String propertyName, Object value) {
        this.ruleList.add(new Rule(4, propertyName, value));
        return this;
    }

    public ParamSqlUtils addLike(String propertyName, Object value) {
        if (value instanceof String) {
            String str = (String)value;
            str = StringUtils.replace(str, "*", "%");
            str = StringUtils.replace(str, "%%", "%");
            if ((str = str.trim()).equals("%")) {
                return this;
            }
        }
        this.ruleList.add(new Rule(1, propertyName, value));
        return this;
    }

    public ParamSqlUtils addIn(String propertyName, Object[] values) {
        this.ruleList.add(new Rule(2, propertyName, values));
        return this;
    }

    public ParamSqlUtils addBetween(String propertyName, Object start, Object end) {
        this.ruleList.add(new Rule(3, propertyName, new Object[]{start, end}));
        return this;
    }

    public ParamSqlUtils addNotEqual(String propertyName, Object value) {
        this.ruleList.add(new Rule(5, propertyName, value));
        return this;
    }

    public ParamSqlUtils addGreaterThan(String propertyName, Object value) {
        this.ruleList.add(new Rule(6, propertyName, value));
        return this;
    }

    public ParamSqlUtils addGreaterEqual(String propertyName, Object value) {
        this.ruleList.add(new Rule(7, propertyName, value));
        return this;
    }

    public ParamSqlUtils addLessThan(String propertyName, Object value) {
        this.ruleList.add(new Rule(8, propertyName, value));
        return this;
    }

    public ParamSqlUtils addLessEqual(String propertyName, Object value) {
        this.ruleList.add(new Rule(9, propertyName, value));
        return this;
    }

    public class Rule
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int type;
        private boolean comsumed;
        private String propertyName;
        private Object[] values;

        public Rule(int type, String propertyName) {
            this.propertyName = propertyName;
            this.type = type;
        }

        public Rule(int type, String propertyName, Object object) {
            this.propertyName = propertyName;
            this.values = new Object[]{object};
            this.type = type;
        }

        public Rule(int type, String propertyName, Object[] objects) {
            this.propertyName = propertyName;
            this.values = objects;
            this.type = type;
        }

        public Object[] getValues() {
            return this.values;
        }

        public int getType() {
            return this.type;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public boolean isComsumed() {
            return this.comsumed;
        }

        public void setComsumed(boolean comsumed) {
            this.comsumed = comsumed;
        }
    }
}

