/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.common.util;

import com.sinosoft.sysframework.common.datatype.DateTime;
import com.sinosoft.sysframework.common.util.FileUtils;
import com.sinosoft.sysframework.common.util.ObjectUtils;
import com.sinosoft.sysframework.common.util.StringUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParamUtils {
    private static Log logger = LogFactory.getLog((Class)(class$com$sinosoft$sysframework$common$util$ParamUtils == null ? (class$com$sinosoft$sysframework$common$util$ParamUtils = ParamUtils.class$("com.sinosoft.sysframework.common.util.ParamUtils")) : class$com$sinosoft$sysframework$common$util$ParamUtils));
    private HttpServletRequest request;
    private boolean isMultipart;
    private Object[] fileItemList;
    private File repository;
    private String tempRepository = System.getProperty("java.io.tmpdir");
    private DiskFileUpload fu;
    private static Character defalutCharacter = new Character('0');
    static /* synthetic */ Class class$com$sinosoft$sysframework$common$util$ParamUtils;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;

    public ParamUtils(HttpServletRequest request, File repository, int sizeMax, int sizeThreshold) throws ServletException {
        this.request = request;
        this.isMultipart = FileUploadBase.isMultipartContent((HttpServletRequest)request);
        if (!this.isMultipart) {
            return;
        }
        if (repository == null) {
            repository = new File(System.getProperty("java.io.tmpdir"));
            logger.debug((Object)("Repository has no value. set to " + repository.getPath()));
        }
        this.repository = repository;
        this.fu = new DiskFileUpload();
        this.fu.setSizeMax((long)sizeMax);
        this.fu.setSizeThreshold(sizeThreshold);
        this.fu.setRepositoryPath(this.tempRepository);
        try {
            this.fileItemList = this.fu.parseRequest(request).toArray();
        }
        catch (FileUploadException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public ParamUtils(HttpServletRequest request, File repository) throws ServletException {
        this(request, repository, 0x6400000, 8192);
    }

    public ParamUtils(HttpServletRequest request) throws ServletException {
        this(request, null, 0x6400000, 8192);
    }

    public String getParameter(String name) throws ServletException {
        if (!this.isMultipart) {
            return this.request.getParameter(name);
        }
        String value = null;
        int n = this.fileItemList.length;
        for (int i = 0; i < n; ++i) {
            FileItem item = (FileItem)this.fileItemList[i];
            if (!item.getFieldName().equals(name)) continue;
            if (item.isFormField()) {
                value = item.getString();
                break;
            }
            if (item.getName().equals("")) {
                value = "";
                break;
            }
            File file = FileUtils.getUniqueFile(this.repository, item.getName());
            try {
                item.write(file);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            value = file.getPath();
            break;
        }
        return value;
    }

    public int getIntParameter(String name, int defaultNum) throws ServletException {
        String temp = this.getParameter(name);
        if (temp != null && !temp.equals("")) {
            int num = defaultNum;
            try {
                num = Integer.parseInt(this.correctNumber(temp));
            }
            catch (Exception ignored) {
                logger.debug((Object)("ParamUtils.getIntParameter exception:" + ignored.getMessage()), (Throwable)ignored);
            }
            return num;
        }
        return defaultNum;
    }

    public long getLongParameter(String name, long defaultNum) throws ServletException {
        String temp = this.getParameter(name);
        if (temp != null && !temp.equals("")) {
            long num = defaultNum;
            try {
                num = Long.parseLong(this.correctNumber(temp));
            }
            catch (Exception ignored) {
                logger.debug((Object)("ParamUtils.getLongParameter exception:" + ignored.getMessage()), (Throwable)ignored);
            }
            return num;
        }
        return defaultNum;
    }

    public double getDoubleParameter(String name, double defaultNum) throws ServletException {
        String temp = this.getParameter(name);
        if (temp != null && !temp.equals("")) {
            double num = defaultNum;
            try {
                num = Double.parseDouble(this.correctNumber(temp));
            }
            catch (Exception ignored) {
                logger.debug((Object)("ParamUtils.getDoubleParameter exception:" + ignored.getMessage()), (Throwable)ignored);
            }
            return num;
        }
        return defaultNum;
    }

    public int[] getIntParameterValues(String name, int defaultNum) throws ServletException {
        String[] paramValues = this.getParameterValues(name);
        if (paramValues == null) {
            return null;
        }
        int paramValuesCount = paramValues.length;
        if (paramValuesCount < 1) {
            return new int[0];
        }
        int[] values = new int[paramValuesCount];
        for (int i = 0; i < paramValuesCount; ++i) {
            try {
                values[i] = Integer.parseInt(this.correctNumber(paramValues[i]));
                continue;
            }
            catch (Exception e) {
                logger.debug((Object)("ParamUtils.getIntParameterValues exception:" + e.getMessage()), (Throwable)e);
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public long[] getLongParameterValues(String name, long defaultNum) throws ServletException {
        String[] paramValues = this.getParameterValues(name);
        if (paramValues == null) {
            return null;
        }
        int paramValuesCount = paramValues.length;
        if (paramValuesCount < 1) {
            return new long[0];
        }
        long[] values = new long[paramValuesCount];
        for (int i = 0; i < paramValuesCount; ++i) {
            try {
                values[i] = Long.parseLong(this.correctNumber(paramValues[i]));
                continue;
            }
            catch (Exception e) {
                logger.debug((Object)("ParamUtils.getLongParameterValues exception:" + e.getMessage()), (Throwable)e);
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public double[] getDoubleParameterValues(String name, double defaultNum) throws ServletException {
        String[] paramValues = this.getParameterValues(name);
        if (paramValues == null) {
            return null;
        }
        int paramValuesCount = paramValues.length;
        if (paramValuesCount < 1) {
            return new double[0];
        }
        double[] values = new double[paramValuesCount];
        for (int i = 0; i < paramValuesCount; ++i) {
            try {
                values[i] = Double.parseDouble(this.correctNumber(paramValues[i]));
                continue;
            }
            catch (Exception e) {
                logger.debug((Object)("ParamUtils.getDoubleParameterValues exception:" + e.getMessage()), (Throwable)e);
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public String[] getParameterValues(String name) throws ServletException {
        if (!this.isMultipart) {
            return this.request.getParameterValues(name);
        }
        ArrayList<String> values = new ArrayList<String>();
        String value = "";
        int n = this.fileItemList.length;
        for (int i = 0; i < n; ++i) {
            FileItem item = (FileItem)this.fileItemList[i];
            if (!item.getFieldName().equals(name)) continue;
            if (item.isFormField()) {
                value = item.getString();
                values.add(value);
                continue;
            }
            if (item.getName().equals("")) {
                value = "";
            } else {
                File file = FileUtils.getUniqueFile(this.repository, item.getName());
                try {
                    item.write(file);
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
                value = file.getPath();
            }
            values.add(value);
        }
        String[] retValues = new String[values.size()];
        if (retValues.length == 0) {
            retValues = null;
        } else {
            values.toArray(retValues);
        }
        return retValues;
    }

    public boolean isMultipart() {
        return this.isMultipart;
    }

    public File getRepository() {
        return this.repository;
    }

    public void setRepository(File repository) {
        this.repository = repository;
    }

    public Object[] getFileItemList() {
        return this.fileItemList;
    }

    public String getTempRepository() {
        return this.tempRepository;
    }

    public void setTempRepository(String tempRepository) {
        File tempDir = new File(tempRepository);
        if (tempDir.exists() && tempDir.canRead() && tempDir.canWrite()) {
            this.tempRepository = tempRepository;
            this.fu.setRepositoryPath(tempRepository);
        } else {
            logger.debug((Object)"ParamUtils.setTempRepository\u8bbe\u7f6e\u4e34\u65f6\u5b58\u50a8\u8def\u5f84\u5931\u8d25\uff01");
        }
    }

    private synchronized String correctNumber(String numberString) {
        String value = numberString;
        if (value != null && !value.equals("")) {
            value = StringUtils.replace(value, ",", "");
        }
        return value;
    }

    public Object generateObject(Class cl, String inputPrefix) throws Exception {
        Object object = cl.newInstance();
        boolean needTrim = false;
        String actionType = this.request.getParameter("actionType");
        if (actionType != null && (actionType.toLowerCase().startsWith("find") || actionType.toLowerCase().startsWith("query"))) {
            needTrim = true;
        }
        List methodList = ObjectUtils.getSetter(cl);
        int methodLength = methodList.size();
        for (int i = 0; i < methodLength; ++i) {
            String fieldName;
            Method method = (Method)methodList.get(i);
            if (method.getName().endsWith("Object_OrderBy") || method.getName().endsWith("Object_Condition")) {
                method.invoke(object, "");
                continue;
            }
            String stripped = fieldName = method.getName().substring(3);
            if (inputPrefix != null && inputPrefix.trim().length() > 0) {
                stripped = inputPrefix + StringUtils.upperCaseFirstChar(fieldName);
            }
            Object parameterValue = this.request.getParameter(stripped);
            try {
                DateTime d;
                Class<?> parameterType = method.getParameterTypes()[0];
                if (parameterValue == null) {
                    if (parameterType.isPrimitive()) {
                        if (parameterType.getClass() == Boolean.TYPE) {
                            method.invoke(object, Boolean.FALSE);
                            continue;
                        }
                        if (parameterType.getClass() == Byte.TYPE) {
                            method.invoke(object, Byte.valueOf("0"));
                            continue;
                        }
                        if (parameterType.getClass() == Character.TYPE) {
                            method.invoke(object, defalutCharacter);
                            continue;
                        }
                        if (parameterType.getClass() == Short.TYPE) {
                            method.invoke(object, Short.valueOf("0"));
                            continue;
                        }
                        if (parameterType.getClass() == Integer.TYPE) {
                            method.invoke(object, Integer.valueOf("0"));
                            continue;
                        }
                        if (parameterType.getClass() == Long.TYPE) {
                            method.invoke(object, Long.valueOf("0"));
                            continue;
                        }
                        if (parameterType.getClass() == Float.TYPE) {
                            method.invoke(object, Float.valueOf("0"));
                            continue;
                        }
                        if (parameterType.getClass() != Double.TYPE) continue;
                        method.invoke(object, Double.valueOf("0"));
                        continue;
                    }
                    method.invoke(object, new Object[]{null});
                    continue;
                }
                Object valueString = parameterValue;
                if (valueString == null) {
                    valueString = "";
                }
                if (((String)valueString).equalsIgnoreCase("null")) {
                    valueString = "";
                }
                valueString = needTrim ? ((String)valueString).trim() : StringUtils.rightTrim((String)valueString);
                parameterValue = parameterType == (class$java$sql$Timestamp == null ? ParamUtils.class$("java.sql.Timestamp") : class$java$sql$Timestamp) ? ((d = this.getDateTime((String)valueString)) == null ? null : new Timestamp(d.getTime())) : (parameterType == (class$java$util$Date == null ? ParamUtils.class$("java.util.Date") : class$java$util$Date) ? ((d = this.getDateTime((String)valueString)) == null ? null : d) : (parameterType == (class$java$lang$Double == null ? ParamUtils.class$("java.lang.Double") : class$java$lang$Double) ? (valueString == null || ((String)valueString).equals("") ? null : Double.valueOf(this.correctNumber((String)valueString))) : (parameterType == (class$java$lang$Long == null ? ParamUtils.class$("java.lang.Long") : class$java$lang$Long) ? (valueString == null || ((String)valueString).equals("") ? null : Long.valueOf(this.correctNumber((String)valueString))) : (parameterType == (class$java$lang$Integer == null ? ParamUtils.class$("java.lang.Integer") : class$java$lang$Integer) ? (valueString == null || ((String)valueString).equals("") ? null : Integer.valueOf(this.correctNumber((String)valueString))) : valueString))));
                method.invoke(object, parameterValue);
                continue;
            }
            catch (Exception e) {
                logger.debug((Object)("ParamUtils.generateObject exception:" + e.getMessage()), (Throwable)e);
            }
        }
        return object;
    }

    public List generateList(Class cl, String inputPrefix) throws Exception {
        return this.generateList(cl, inputPrefix, 1);
    }

    public List generateList(Class cl, String inputPrefix, int startIndex) throws Exception {
        ArrayList resultList = new ArrayList();
        List methodList = ObjectUtils.getSetter(cl);
        TreeMap treeMap = new TreeMap();
        if (startIndex < 0) {
            startIndex = 0;
        }
        int methodLength = methodList.size();
        for (int i = 0; i < methodLength; ++i) {
            String[] parameterValue;
            String fieldName;
            Method method = (Method)methodList.get(i);
            String stripped = fieldName = method.getName().substring(3);
            if (inputPrefix != null && inputPrefix.trim().length() > 0) {
                stripped = inputPrefix + StringUtils.upperCaseFirstChar(fieldName);
            }
            if ((parameterValue = this.request.getParameterValues(stripped)) == null) continue;
            for (int j = startIndex; j < parameterValue.length; ++j) {
                Object object = cl.newInstance();
                treeMap.put(new Integer(j), object);
            }
            break;
        }
        if (treeMap.isEmpty()) {
            return resultList;
        }
        HashSet<Integer> treeKeySet = new HashSet<Integer>();
        for (int i = 0; i < methodLength; ++i) {
            String[] parameterValue;
            String fieldName;
            Method method = (Method)methodList.get(i);
            if (method.getName().endsWith("Object_OrderBy") || method.getName().endsWith("Object_Condition")) continue;
            String stripped = fieldName = method.getName().substring(3);
            if (inputPrefix != null && inputPrefix.trim().length() > 0) {
                stripped = inputPrefix + StringUtils.upperCaseFirstChar(fieldName);
            }
            if ((parameterValue = this.request.getParameterValues(stripped)) == null) continue;
            for (int j = startIndex; j < parameterValue.length; ++j) {
                try {
                    Class<?> parameterType = method.getParameterTypes()[0];
                    Object object = treeMap.get(new Integer(j));
                    if (object == null) continue;
                    if (parameterValue == null) {
                        if (parameterType.isPrimitive()) {
                            if (parameterType.getClass() == Boolean.TYPE) {
                                method.invoke(object, Boolean.FALSE);
                            } else if (parameterType.getClass() == Byte.TYPE) {
                                method.invoke(object, Byte.valueOf("0"));
                            } else if (parameterType.getClass() == Character.TYPE) {
                                method.invoke(object, defalutCharacter);
                            } else if (parameterType.getClass() == Short.TYPE) {
                                method.invoke(object, Short.valueOf("0"));
                            } else if (parameterType.getClass() == Integer.TYPE) {
                                method.invoke(object, Integer.valueOf("0"));
                            } else if (parameterType.getClass() == Long.TYPE) {
                                method.invoke(object, Long.valueOf("0"));
                            } else if (parameterType.getClass() == Float.TYPE) {
                                method.invoke(object, Float.valueOf("0"));
                            } else if (parameterType.getClass() == Double.TYPE) {
                                method.invoke(object, Double.valueOf("0"));
                            }
                        } else {
                            method.invoke(object, new Object[]{null});
                        }
                    } else {
                        DateTime d;
                        Object value = parameterValue[j];
                        Object valueString = value;
                        if (((String)valueString).equalsIgnoreCase("null")) {
                            valueString = "";
                        }
                        valueString = StringUtils.rightTrim((String)valueString);
                        if (parameterType == (class$java$sql$Timestamp == null ? ParamUtils.class$("java.sql.Timestamp") : class$java$sql$Timestamp)) {
                            d = this.getDateTime((String)valueString);
                            value = d == null ? null : new Timestamp(d.getTime());
                        } else if (parameterType == (class$java$util$Date == null ? ParamUtils.class$("java.util.Date") : class$java$util$Date)) {
                            d = this.getDateTime((String)valueString);
                            value = d == null ? null : d;
                        } else if (parameterType == (class$java$lang$Double == null ? ParamUtils.class$("java.lang.Double") : class$java$lang$Double)) {
                            value = valueString == null || ((String)valueString).equals("") ? null : Double.valueOf(this.correctNumber((String)valueString));
                        } else if (parameterType == (class$java$lang$Long == null ? ParamUtils.class$("java.lang.Long") : class$java$lang$Long)) {
                            value = valueString == null || ((String)valueString).equals("") ? null : Long.valueOf(this.correctNumber((String)valueString));
                        } else if (parameterType == (class$java$lang$Integer == null ? ParamUtils.class$("java.lang.Integer") : class$java$lang$Integer)) {
                            value = valueString == null || ((String)valueString).equals("") ? null : Integer.valueOf(this.correctNumber((String)valueString));
                        }
                        method.invoke(object, value);
                    }
                    if (treeKeySet.contains(new Integer(j))) continue;
                    resultList.add(object);
                    treeKeySet.add(new Integer(j));
                    continue;
                }
                catch (Exception e) {
                    logger.debug((Object)("ParamUtils.generateList exception:" + e.getMessage()), (Throwable)e);
                }
            }
        }
        return resultList;
    }

    public DateTime getDateTime(String value) {
        DateTime d = null;
        if (value.trim().length() == 0) {
            return d;
        }
        try {
            d = new DateTime(value, 17);
        }
        catch (IllegalArgumentException e1) {
            try {
                d = new DateTime(value, 16);
            }
            catch (IllegalArgumentException e2) {
                try {
                    d = new DateTime(value, 14);
                }
                catch (IllegalArgumentException e3) {
                    try {
                        d = new DateTime(value, 13);
                    }
                    catch (IllegalArgumentException e4) {
                        // empty catch block
                    }
                }
            }
        }
        return d;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

