/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.common.util;

import com.sinosoft.sysframework.common.datatype.DateTime;
import com.sinosoft.sysframework.common.util.ObjectUtils;
import com.sinosoft.sysframework.common.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class SqlUtils {
    public static final String QUERY_FIELD_SUFFIX = "_ForQuery";
    private static final String[] FORBID_STRING = new String[]{" or "};
    private static final String[] OPERATE_SIGN = new String[]{">", "<", "=", "!="};
    private static final String[] FILTERED_STRING = new String[]{" ", "%", "*", "?"};
    public static final int ANSI_DB = 0;
    public static final int ORACLE_DB = 1;
    public static final int DB2_DB = 2;
    private static int dbType = 0;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Date;

    private SqlUtils() {
    }

    public static String addConditions(Object object, String[] propertyArray) {
        StringBuffer buffer = new StringBuffer(100);
        if (propertyArray == null) {
            return "";
        }
        for (int i = 0; i < propertyArray.length; ++i) {
            buffer.append(SqlUtils.addCondition(null, object, propertyArray[i]));
        }
        return buffer.toString();
    }

    public static String addConditions(Object object, String[] propertyArray, String alias) {
        StringBuffer buffer = new StringBuffer(100);
        if (propertyArray == null) {
            return "";
        }
        for (int i = 0; i < propertyArray.length; ++i) {
            buffer.append(SqlUtils.addCondition(alias, object, propertyArray[i]));
        }
        return buffer.toString();
    }

    public static String addConditions(Object object, String alias) {
        StringBuffer buffer = new StringBuffer(100);
        if (object == null) {
            return "";
        }
        Class<?> cl = object.getClass();
        if (cl != null && cl.getSuperclass() != null) {
            String className = ObjectUtils.getClassNameWithoutPackage(cl);
            String superName = ObjectUtils.getClassNameWithoutPackage(cl.getSuperclass());
            if ((className + "Base").equals(superName)) {
                cl = cl.getSuperclass();
            }
        }
        List methodList = ObjectUtils.getSetter(cl);
        for (int i = 0; i < methodList.size(); ++i) {
            Method method = (Method)methodList.get(i);
            String fieldName = method.getName().substring(3);
            if (fieldName.endsWith(QUERY_FIELD_SUFFIX) || fieldName.equalsIgnoreCase("Object_OrderBy") || fieldName.equalsIgnoreCase("Object_Condition")) continue;
            fieldName = StringUtils.lowerCaseFirstChar(fieldName);
            String sql = SqlUtils.addCondition(alias, object, fieldName);
            buffer.append(sql);
        }
        return buffer.toString();
    }

    public static String addCondition(Object object, String propertyName, String alias) {
        return SqlUtils.addCondition(alias, object, propertyName);
    }

    private static String addCondition(String alias, Object object, String pName) {
        StringBuffer buffer = new StringBuffer();
        String value = "";
        Class type = null;
        try {
            type = PropertyUtils.getPropertyType((Object)object, (String)pName);
            value = BeanUtils.getProperty((Object)object, (String)pName);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Illegal access exception");
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Invocation target exception");
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No getter method for field " + pName);
        }
        if (value == null && type != (class$java$lang$String == null ? (class$java$lang$String = SqlUtils.class$("java.lang.String")) : class$java$lang$String)) {
            try {
                value = BeanUtils.getProperty((Object)object, (String)(pName + QUERY_FIELD_SUFFIX));
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Illegal access exception");
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Illegal access exception");
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (value != null && value.length() > 0) {
            value = StringUtils.replace(value, "*", "%");
            value = StringUtils.replace(value, "%%", "%");
            value = StringUtils.replace(value, "??", "?");
            String fieldName = "";
            fieldName = alias != null && alias.trim().length() > 0 ? alias + "." + pName : pName;
            if (type == (class$java$util$Date == null ? (class$java$util$Date = SqlUtils.class$("java.util.Date")) : class$java$util$Date) || type == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = SqlUtils.class$("java.sql.Timestamp")) : class$java$sql$Timestamp) || type == (class$java$sql$Date == null ? (class$java$sql$Date = SqlUtils.class$("java.sql.Date")) : class$java$sql$Date)) {
                buffer.append(SqlUtils.convertDate(fieldName, value));
            } else if (type == (class$java$lang$String == null ? (class$java$lang$String = SqlUtils.class$("java.lang.String")) : class$java$lang$String)) {
                buffer.append(SqlUtils.convertString(fieldName, value));
            } else {
                buffer.append(SqlUtils.convertNumber(fieldName, value));
            }
        }
        return buffer.toString();
    }

    public static String getWherePartForGetCount(String wherePart) {
        String sqlForGetCount = wherePart;
        int pos = 0;
        pos = StringUtils.indexOf(sqlForGetCount.toLowerCase(), " order by ", 0, false);
        if (pos > 0) {
            int pos2 = sqlForGetCount.indexOf(")", pos);
            sqlForGetCount = pos2 == -1 ? sqlForGetCount.substring(0, pos) : sqlForGetCount.substring(0, pos) + sqlForGetCount.substring(pos2);
        }
        return sqlForGetCount;
    }

    public static String convertString(String name, String value) {
        StringBuffer buffer = new StringBuffer();
        SqlUtils.checkParamValue(value);
        if (value == null || value.equals("")) {
            return "";
        }
        value = StringUtils.replace(value, "*", "%");
        value = StringUtils.replace(value, "%%", "%");
        if ((value = StringUtils.replace(value, "??", "?")).indexOf(",") > -1) {
            String[] values = StringUtils.split(value, ",");
            buffer.append(" AND (").append(name).append(" IN (");
            int n = values.length;
            for (int i = 0; i < n; ++i) {
                buffer.append("'").append(values[i]).append("'");
                if (i >= n - 1) continue;
                buffer.append(",");
            }
            buffer.append(")) ");
        } else if (value.indexOf("?") > -1 || value.indexOf("%") > -1) {
            if (value.startsWith("?") || value.startsWith("%")) {
                buffer.append(" AND (").append(name).append(" = '").append(value).append("') ");
            } else {
                boolean containsFilteredCharOnly = SqlUtils.containsFilteredCharOnly(value);
                if (containsFilteredCharOnly) {
                    buffer.append(" AND (").append(name).append(" = '").append(value).append("') ");
                } else {
                    buffer.append(" AND (").append(name).append(" LIKE '").append(value).append("') ");
                }
            }
        } else {
            String valueStart = "";
            String valueEnd = "";
            int index = value.indexOf(58);
            if (index > -1) {
                valueStart = value.substring(0, index).trim();
                valueEnd = value.substring(index + 1).trim();
                buffer.append(" AND (").append(name).append(" BETWEEN '").append(valueStart).append("' AND '").append(valueEnd).append("') ");
            } else if (SqlUtils.hasOperateSign(value)) {
                buffer.append(" AND (").append(name).append(value).append(") ");
            } else {
                buffer.append(" AND (").append(name).append(" = '").append(value).append("') ");
            }
        }
        return buffer.toString();
    }

    public static String convertDate(String name, String value) {
        StringBuffer buffer = new StringBuffer();
        SqlUtils.checkParamValue(value);
        if (value == null || value.equals("")) {
            return "";
        }
        if (value.indexOf(",") > -1) {
            String[] values = StringUtils.split(value, ",");
            if (dbType == 2) {
                buffer.append(" AND (date(").append(name).append(") IN (");
            } else {
                buffer.append(" AND (").append(name).append(" IN (");
            }
            int n = values.length;
            for (int i = 0; i < n; ++i) {
                String dateValue = values[i].trim();
                dateValue = StringUtils.replace(dateValue, "'", "");
                dateValue = dateValue.trim();
                if (dbType == 1) {
                    dateValue = StringUtils.replace(dateValue, "/", "-");
                    buffer.append("to_date('").append(dateValue).append("', 'YYYY-MM-DD HH24:MI:SS')");
                } else if (dbType == 2) {
                    buffer.append("date('").append(dateValue).append("'");
                } else {
                    buffer.append("'").append(dateValue).append("'");
                }
                if (i >= n - 1) continue;
                buffer.append(",");
            }
            buffer.append(")) ");
        } else {
            String valueStart = "";
            String valueEnd = "";
            value = StringUtils.replace(value.trim(), "'", "");
            value = value.trim();
            int foundCount = StringUtils.timesOf(value, ':');
            boolean isBetween = false;
            if (foundCount > 0 && foundCount % 2 == 1) {
                isBetween = true;
                int index = StringUtils.indexOf(value, ":", 0, foundCount / 2 + 1);
                valueStart = value.substring(0, index);
                valueEnd = value.substring(index + 1);
                if (foundCount == 1 && valueStart.length() < 3) {
                    isBetween = false;
                }
            }
            if (isBetween) {
                if (dbType == 1) {
                    buffer.append(" AND (").append(name).append(" BETWEEN to_date('").append(valueStart.trim()).append("', 'YYYY-MM-DD HH24:MI:SS') AND to_date('").append(valueEnd.trim()).append("', 'YYYY-MM-DD HH24:MI:SS')) ");
                } else if (dbType == 2) {
                    buffer.append(" AND ( date(").append(name).append(") BETWEEN date('").append(valueStart.trim()).append("') AND date('").append(valueEnd.trim()).append("')) ");
                } else {
                    buffer.append(" AND (").append(name).append(" BETWEEN '").append(valueStart.trim()).append("' AND '").append(valueEnd.trim()).append("') ");
                }
            } else if (SqlUtils.hasOperateSign(value)) {
                String[] operateSignAndTrueValue = SqlUtils.splitOperateSignAndTrueValue(value);
                String operateSign = operateSignAndTrueValue[0];
                String trueValue = operateSignAndTrueValue[1];
                if (dbType == 1) {
                    buffer.append(" AND (").append(name).append(operateSign).append("to_date('").append(trueValue).append("', 'YYYY-MM-DD HH24:MI:SS')) ");
                } else if (dbType == 2) {
                    buffer.append(" AND ( date(").append(name).append(")").append(operateSign).append("date('").append(trueValue).append("')) ");
                } else {
                    buffer.append(" AND (").append(name).append(operateSign).append(" '").append(trueValue).append("') ");
                }
            } else if (dbType == 1) {
                buffer.append(" AND (").append(name).append(">=to_date('").append(new DateTime(value).toString(13)).append(" 00:00:00', 'YYYY-MM-DD HH24:MI:SS') AND ").append(name).append("<=to_date('").append(new DateTime(value).toString(13)).append(" 23:59:59', 'YYYY-MM-DD HH24:MI:SS')) ");
            } else if (dbType == 2) {
                buffer.append(" AND (date(").append(name).append(") = date('").append(value).append("')) ");
            } else {
                buffer.append(" AND (").append(name).append(" = '").append(value).append("') ");
            }
        }
        return buffer.toString();
    }

    public static String convertNumber(String name, String value) {
        StringBuffer strReturn = new StringBuffer();
        SqlUtils.checkParamValue(value);
        if (value == null || value.equals("")) {
            return "";
        }
        if (value.indexOf(",") > -1) {
            String[] values = StringUtils.split(value, ",");
            strReturn.append(" AND (").append(name).append(" IN (");
            int n = values.length;
            for (int i = 0; i < n; ++i) {
                strReturn.append("'").append(values[i]).append("'");
                if (i >= n - 1) continue;
                strReturn.append(",");
            }
            strReturn.append(")) ");
        } else {
            String valueStart = "";
            String valueEnd = "";
            int index = value.indexOf(58);
            if (index > -1) {
                valueStart = value.substring(0, index);
                valueEnd = value.substring(index + 1);
                strReturn.append(" AND (").append(name).append(" BETWEEN ").append(valueStart).append(" AND ").append(valueEnd).append(") ");
            } else if (SqlUtils.hasOperateSign(value)) {
                strReturn.append(" AND (").append(name).append(value).append(") ");
            } else {
                strReturn.append(" AND (").append(name).append(" = ").append(value).append(") ");
            }
        }
        return strReturn.toString();
    }

    private static void checkParamValue(String value) {
        if (value == null || value.equals("")) {
            return;
        }
        value = value.toLowerCase();
        for (int i = 0; i < FORBID_STRING.length; ++i) {
            if (value.indexOf(FORBID_STRING[i]) == -1) continue;
            throw new IllegalArgumentException("Illegal query string " + FORBID_STRING[i]);
        }
    }

    private static boolean hasOperateSign(String value) {
        boolean result = false;
        value = StringUtils.absoluteTrim(value);
        for (int i = 0; i < OPERATE_SIGN.length; ++i) {
            if (value.indexOf(OPERATE_SIGN[i]) == -1) continue;
            result = true;
            break;
        }
        return result;
    }

    private static String[] splitOperateSignAndTrueValue(String value) {
        value = StringUtils.leftTrim(value);
        value = StringUtils.rightTrim(value);
        String operateSign = null;
        String trueValue = null;
        if (value.length() >= 2) {
            if (SqlUtils.hasOperateSign(value.substring(1, 2))) {
                operateSign = value.substring(0, 2);
                trueValue = value.substring(2);
            } else {
                operateSign = value.substring(0, 1);
                trueValue = value.substring(1);
            }
        } else {
            operateSign = value;
            trueValue = "";
        }
        return new String[]{operateSign, trueValue};
    }

    public static int getDbType() {
        return dbType;
    }

    public static void setDbType(int dbType) {
        SqlUtils.dbType = dbType;
    }

    public static String join(String selectPart, String conditionsPart) {
        if (conditionsPart == null) {
            return selectPart;
        }
        conditionsPart = SqlUtils.trimStartsWithAnd(conditionsPart);
        StringBuffer sql = new StringBuffer(32);
        sql.append(selectPart);
        if (conditionsPart.trim().length() > 0) {
            sql.append(" where ");
            sql.append(conditionsPart);
        }
        return sql.toString();
    }

    public static String trimStartsWithAnd(String sql) {
        if (sql == null) {
            return "";
        }
        StringBuffer value = new StringBuffer(sql);
        try {
            String regex = "^\\s*and{1}\\s+";
            Perl5Compiler compiler = new Perl5Compiler();
            Perl5Matcher matcher = new Perl5Matcher();
            Pattern pattern = compiler.compile("^\\s*and{1}\\s+", 1);
            if (matcher.contains(value.toString(), pattern)) {
                MatchResult result = matcher.getMatch();
                int beginOffset = result.beginOffset(0);
                int endOffset = result.endOffset(0);
                value = value.delete(beginOffset, endOffset);
            }
        }
        catch (Exception e) {
            value = new StringBuffer(sql);
            e.printStackTrace();
        }
        return value.toString();
    }

    protected static boolean containsFilteredCharOnly(String condition) {
        boolean containsFilteredCharOnly = true;
        for (int i = 0; i < condition.length(); ++i) {
            String str = condition.substring(i, i + 1);
            if (ArrayUtils.contains((Object[])FILTERED_STRING, (Object)str)) continue;
            containsFilteredCharOnly = false;
            break;
        }
        return containsFilteredCharOnly;
    }

    public static void main(String[] args) {
        String sqlString = "SELECT count(*) FROM (SELECT * FROM PrpDCatastrophe WHERE 1=1 ORDER BY CatastropheCode)";
        if (sqlString.toUpperCase().startsWith("SELECT COUNT(*) FROM")) {
            sqlString = SqlUtils.getWherePartForGetCount(sqlString);
        }
        System.out.println(sqlString);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

