/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.log;

import com.sinosoft.sysframework.common.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public class Logger {
    org.apache.log4j.Logger myLogger;
    private static Hashtable loggers = new Hashtable();
    private static boolean init = false;
    private static final File CONFIG_FILE = FileUtils.getUniqueFile(class$com$sinosoft$sysframework$log$Logger == null ? (class$com$sinosoft$sysframework$log$Logger = Logger.class$("com.sinosoft.sysframework.log.Logger")) : class$com$sinosoft$sysframework$log$Logger, ".config");
    private static long lastModified = 0L;
    private static File localConfigFile;
    static /* synthetic */ Class class$com$sinosoft$sysframework$log$Logger;

    public static synchronized void configure(String fileName) throws Exception {
        if (!init) {
            Logger.reconfigure(fileName);
        }
    }

    public static synchronized void reconfigure(String fileName) throws Exception {
        try {
            localConfigFile = new File(fileName);
            lastModified = localConfigFile.lastModified();
            FileUtils.write(fileName, CONFIG_FILE);
            PropertyConfigurator.configure((String)fileName);
            System.out.println("Success load Logger configuration at \"" + fileName + "\".");
            init = true;
        }
        catch (Exception e) {
            System.out.println("Fail load Logger configuration at \"" + fileName + "\".");
            throw e;
        }
    }

    public static synchronized void configure(InputStream inputStream) throws IOException {
        BufferedInputStream is = new BufferedInputStream(inputStream);
        Properties prop = new Properties();
        prop.load(is);
        is.close();
        Logger.configure(prop);
    }

    private static synchronized void configure(Properties properties) {
        PropertyConfigurator.configure((Properties)properties);
    }

    public static synchronized Logger getLogger(Class name) {
        return Logger.getLogger(name.getName());
    }

    public static synchronized Logger getLogger(String name) {
        if (loggers.containsKey(name)) {
            return (Logger)loggers.get(name);
        }
        Logger log = new Logger();
        log.myLogger = org.apache.log4j.Logger.getLogger((String)name);
        loggers.put(name, log);
        return log;
    }

    public void debug(String output) {
        this.debug(null, output);
    }

    public void info(String output) {
        this.info(null, output);
    }

    public void warn(String output) {
        this.warn(null, output);
    }

    public void error(String output) {
        this.error(null, output);
    }

    public void debug(String name, String output) {
        Logger.checkConfig();
        if (name != null && name.trim().length() > 0) {
            output = "[" + name.trim() + "] " + output;
        }
        this.myLogger.debug((Object)output);
    }

    public void info(String name, String output) {
        Logger.checkConfig();
        if (name != null && name.trim().length() > 0) {
            output = "[" + name.trim() + "] " + output;
        }
        this.myLogger.info((Object)output);
    }

    public void warn(String name, String output) {
        Logger.checkConfig();
        if (name != null && name.trim().length() > 0) {
            output = "[" + name.trim() + "] " + output;
        }
        this.myLogger.warn((Object)output);
    }

    public void error(String name, String output) {
        Logger.checkConfig();
        if (name != null && name.trim().length() > 0) {
            output = "[" + name.trim() + "] " + output;
        }
        this.myLogger.error((Object)output);
    }

    public boolean isDebugEnabled() {
        Logger.checkConfig();
        return this.myLogger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        Logger.checkConfig();
        return this.myLogger.isInfoEnabled();
    }

    public final int getLevel() {
        Logger.checkConfig();
        if (this.myLogger.getLevel() == null) {
            return Integer.MAX_VALUE;
        }
        return this.myLogger.getLevel().toInt();
    }

    public static boolean isInit() {
        return init;
    }

    private static void checkConfig() {
        block9: {
            try {
                if (!init) {
                    String fileName;
                    if (!CONFIG_FILE.exists()) {
                        try {
                            if (!CONFIG_FILE.createNewFile()) {
                                System.out.println("Create file " + CONFIG_FILE.getAbsolutePath() + " fail.");
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (CONFIG_FILE.exists() && new File(fileName = FileUtils.read(CONFIG_FILE)).exists()) {
                        Logger.reconfigure(fileName);
                    }
                    break block9;
                }
                if (lastModified < localConfigFile.lastModified()) {
                    Logger.reconfigure(localConfigFile.getAbsolutePath());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

