/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.helpers.Transform;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.xml.XMLLayout;

public class XMLLogLayout
extends XMLLayout {
    private static final int DEFAULT_SIZE = 256;
    private static final int UPPER_LIMIT = 2048;
    private static final String pattern = "yyyy-MM-dd HH:mm:ss:SSS";
    private StringBuffer buf = new StringBuffer(256);
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");

    public String format(LoggingEvent event) {
        String[] s;
        if (this.buf.capacity() > 2048) {
            this.buf = new StringBuffer(256);
        } else {
            this.buf.setLength(0);
        }
        this.buf.append("<log level=\"");
        this.buf.append(event.getLevel());
        this.buf.append("\" date=\"");
        this.buf.append(this.sdf.format(new Date()));
        this.buf.append("\">\r\n");
        this.buf.append("<message><![CDATA[");
        Transform.appendEscapingCDATA((StringBuffer)this.buf, (String)event.getRenderedMessage());
        this.buf.append("]]></message>\r\n");
        String ndc = event.getNDC();
        if (ndc != null) {
            this.buf.append("<ndc><![CDATA[");
            this.buf.append(ndc);
            this.buf.append("]]></ndc>\r\n");
        }
        if ((s = event.getThrowableStrRep()) != null) {
            this.buf.append("<throwable><![CDATA[");
            for (int i = 0; i < s.length; ++i) {
                this.buf.append(s[i]);
                this.buf.append("\r\n");
            }
            this.buf.append("]]></throwable>\r\n");
        }
        if (this.getLocationInfo()) {
            LocationInfo locationInfo = event.getLocationInformation();
            this.buf.append("<location file=\"");
            this.buf.append(locationInfo.getFileName());
            this.buf.append("\" class=\"");
            this.buf.append(Transform.escapeTags((String)locationInfo.getClassName()));
            this.buf.append("\" method=\"");
            this.buf.append(Transform.escapeTags((String)locationInfo.getMethodName()));
            this.buf.append("\" line=\"");
            this.buf.append(locationInfo.getLineNumber());
            this.buf.append("\"/>\r\n");
        }
        this.buf.append("</log>\r\n\r\n");
        return this.buf.toString();
    }

    public void setLocationInfo(boolean flag) {
        super.setLocationInfo(flag);
    }

    public boolean getLocationInfo() {
        return super.getLocationInfo();
    }
}

