/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.validate;

import com.sinosoft.sysframework.common.AppUtils;
import com.sinosoft.sysframework.validate.Resources;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.Var;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.util.MessageResources;

public class JavascriptValidatorTag
extends BodyTagSupport {
    private static final long serialVersionUID = 1L;
    protected static final String HTML_BEGIN_COMMENT = "\n<!-- Begin \n";
    protected static final String HTML_END_COMMENT = "//End --> \n";
    protected static Locale defaultLocale = Locale.getDefault();
    protected String formName = null;
    protected String jsFormName = "fm";
    protected static String lineEnd = System.getProperty("line.separator");
    protected int page = 0;
    protected String methodName = null;
    protected boolean scriptLanguage = true;
    protected String src = null;
    protected String htmlComment = "true";
    protected String cdata = "true";
    protected String bundle = "org.apache.struts.action.MESSAGE";

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String getJsFormName() {
        return this.jsFormName;
    }

    public void setJsFormName(String jsFormName) {
        this.jsFormName = jsFormName;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getMethod() {
        return this.methodName;
    }

    public void setMethod(String methodName) {
        this.methodName = methodName;
    }

    public String getHtmlComment() {
        return this.htmlComment;
    }

    public void setHtmlComment(String htmlComment) {
        this.htmlComment = htmlComment;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public String getBundle() {
        return null;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public int doStartTag() throws JspException {
        JspWriter writer = this.pageContext.getOut();
        try {
            writer.print(this.renderJavascript());
        }
        catch (IOException e) {
            throw new JspException(e.getMessage());
        }
        return 2;
    }

    protected String renderJavascript() throws JspException {
        HttpServletRequest request;
        HttpSession session;
        Locale locale;
        ValidatorResources resources = AppUtils.getValidatorResources();
        Form form = resources.getForm(locale = (Locale)(session = (request = (HttpServletRequest)this.pageContext.getRequest()).getSession()).getAttribute("org.apache.struts.action.LOCALE"), this.formName);
        if (form == null) {
            throw new JspException("No form found under '" + this.formName + "' in locale '" + locale + "'");
        }
        StringBuffer results = new StringBuffer();
        results.append(this.createDynamicJavascript(resources, locale, form));
        results.append(this.getJavascriptEnd());
        return results.toString();
    }

    private String createDynamicJavascript(ValidatorResources resources, Locale locale, Form form) throws JspException {
        StringBuffer results = new StringBuffer();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        ServletContext application = this.pageContext.getServletContext();
        MessageResources messageResources = Resources.getMessageResources(request);
        MessageResources messages = TagUtils.getInstance().retrieveMessageResources(this.pageContext, this.bundle, true);
        String businessType = request.getParameter("businessType");
        if (businessType == null) {
            businessType = (String)request.getAttribute("businessType");
        }
        if (businessType == null) {
            businessType = "";
        }
        businessType = businessType.toLowerCase();
        List actions = this.createActionList(resources, form);
        String methods = this.createMethods(actions);
        results.append(this.getJavascriptBegin(methods));
        Iterator iter = actions.iterator();
        while (iter.hasNext()) {
            ValidatorAction va = (ValidatorAction)iter.next();
            int jscriptVar = 0;
            String functionName = null;
            functionName = va.getJsFunctionName() != null && va.getJsFunctionName().length() > 0 ? va.getJsFunctionName() : va.getName();
            results.append("    function " + this.jsFormName + "_" + functionName + " () { \n");
            StringBuffer buffer = new StringBuffer();
            Iterator x = form.getFields().iterator();
            while (x.hasNext()) {
                String arg0;
                int pos;
                Field field = (Field)x.next();
                if (field.isIndexed() || field.getPage() != this.page || !field.isDependency(va.getName())) continue;
                String dependOnValue = field.getVarValue("dependOn");
                String undependOnValue = field.getVarValue("undependOn");
                if (dependOnValue != null && undependOnValue == null) {
                    Object[] dependOnValueArray;
                    if (businessType.length() == 0 || !ArrayUtils.contains((Object[])(dependOnValueArray = (dependOnValue = dependOnValue.toLowerCase()).split(",")), (Object)businessType)) {
                        continue;
                    }
                } else if (dependOnValue == null && undependOnValue != null) {
                    undependOnValue = undependOnValue.toLowerCase();
                    Object[] undependOnValueArray = undependOnValue.split(",");
                    if (businessType.length() > 0 && ArrayUtils.contains((Object[])undependOnValueArray, (Object)businessType)) continue;
                }
                buffer.setLength(0);
                String inputName = field.getKey();
                if (field.getVarValue("inputName") != null) {
                    inputName = field.getVarValue("inputName");
                }
                buffer.append("new Function (\"varName\", \"");
                Map vars = field.getVars();
                Iterator varsIterator = vars.keySet().iterator();
                boolean hasMultiLine = false;
                while (varsIterator.hasNext()) {
                    String varName = (String)varsIterator.next();
                    Var var = (Var)vars.get(varName);
                    String varValue = var.getValue();
                    String jsType = var.getJsType();
                    if (varName.startsWith("field")) continue;
                    String varValueEscaped = this.escapeJavascript(varValue);
                    if ("int".equalsIgnoreCase(jsType)) {
                        buffer.append("this." + varName + "=" + varValueEscaped + "; ");
                        continue;
                    }
                    if ("regexp".equalsIgnoreCase(jsType)) {
                        buffer.append("this." + varName + "=/" + varValueEscaped + "/; ");
                        continue;
                    }
                    if ("string".equalsIgnoreCase(jsType)) {
                        buffer.append("this." + varName + "='" + varValueEscaped + "'; ");
                        continue;
                    }
                    if ("mask".equalsIgnoreCase(varName)) {
                        buffer.append("this." + varName + "=/" + varValueEscaped + "/; ");
                        continue;
                    }
                    if ("inputName".equalsIgnoreCase(varName)) continue;
                    if ("multiLine".equalsIgnoreCase(varName)) {
                        if (Boolean.valueOf(varValueEscaped).equals(Boolean.TRUE)) {
                            hasMultiLine = true;
                        }
                        buffer.append("this." + varName + "='" + varValueEscaped + "'; ");
                        continue;
                    }
                    buffer.append("this." + varName + "='" + varValueEscaped + "'; ");
                }
                if (!hasMultiLine) {
                    buffer.append("this.multiLine='false'; ");
                }
                buffer.append(" return this[varName];\"));\n");
                String message = Resources.getMessage(application, request, messages, locale, va, field);
                String string = message = message != null ? message : "";
                if (hasMultiLine && (pos = message.indexOf(arg0 = (arg0 = messageResources.getMessage(locale, field.getArg(0).getKey())) != null ? arg0 : "")) > -1) {
                    message = message.substring(0, pos += arg0.length()) + "{_lineNo_}" + message.substring(pos);
                }
                message = message.replaceAll("\\{\\d*\\}", "");
                results.append("     this.a" + jscriptVar++ + " = new Array(\"" + inputName + "\", \"" + this.escapeQuotes(message) + "\", ");
                results.append(buffer);
            }
            results.append("    } \n\n");
        }
        return results.toString();
    }

    private String escapeQuotes(String in) {
        if (in == null || in.indexOf("\"") == -1) {
            return in;
        }
        StringBuffer buffer = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(in, "\"", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("\"")) {
                buffer.append("\\");
            }
            buffer.append(token);
        }
        return buffer.toString();
    }

    private String escapeJavascript(String str) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return str;
        }
        StringBuffer out = new StringBuffer(length + 4);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c == '\"' || c == '\'' || c == '\\' || c == '\n' || c == '\r') {
                out.append('\\');
            }
            out.append(c);
        }
        return out.toString();
    }

    private String createMethods(List actions) {
        StringBuffer methods = new StringBuffer();
        String methodOperator = " && ";
        Iterator iter = actions.iterator();
        while (iter.hasNext()) {
            ValidatorAction va = (ValidatorAction)iter.next();
            if (methods.length() > 0) {
                methods.append(" && ");
            }
            methods.append(va.getMethod()).append("(form)");
        }
        return methods.toString();
    }

    private List createActionList(ValidatorResources resources, Form form) {
        ArrayList actionMethods = new ArrayList();
        Iterator iterator = form.getFields().iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            Iterator x = field.getDependencyList().iterator();
            while (x.hasNext()) {
                Object o = x.next();
                if (o == null || actionMethods.contains(o)) continue;
                actionMethods.add(o);
            }
        }
        ArrayList<ValidatorAction> actions = new ArrayList<ValidatorAction>();
        iterator = actionMethods.iterator();
        while (iterator.hasNext()) {
            String depends = (String)iterator.next();
            ValidatorAction va = resources.getValidatorAction(depends);
            if (va == null) {
                throw new NullPointerException("Depends string \"" + depends + "\" was not found in validator-rules.xml.");
            }
            actions.add(va);
        }
        return actions;
    }

    public void release() {
        super.release();
        this.formName = null;
        this.jsFormName = "fm";
        this.page = 0;
        this.methodName = null;
        this.htmlComment = "true";
        this.cdata = "true";
        this.src = null;
    }

    protected String getJavascriptBegin(String methods) {
        StringBuffer sb = new StringBuffer();
        String name = this.jsFormName.replace('/', '_');
        name = this.jsFormName.substring(0, 1).toUpperCase() + this.jsFormName.substring(1, this.jsFormName.length());
        sb.append(this.renderStartElement());
        if (this.isXhtml() && "true".equalsIgnoreCase(this.cdata)) {
            sb.append("//<![CDATA[\r\n");
        }
        if (!this.isXhtml() && "true".equals(this.htmlComment)) {
            sb.append(HTML_BEGIN_COMMENT);
        }
        sb.append("\n    var bCancel = false; \n\n");
        if (this.methodName == null || this.methodName.length() == 0) {
            sb.append("    function validate" + name + "(form) {                                                                   \n");
        } else {
            sb.append("  function " + this.methodName + "(form) {                                                                   \n");
        }
        sb.append("      if (bCancel){ \n");
        sb.append("        return true; \n");
        sb.append("      }else{ \n");
        if (methods == null || methods.length() == 0) {
            sb.append("        return true; \n");
        } else {
            sb.append("        var formValidationResult;\n");
            sb.append("          formValidationResult = " + methods + "; \n");
            sb.append("        return (formValidationResult == 1);\n");
        }
        sb.append("    } \n");
        sb.append("  }\n");
        return sb.toString();
    }

    protected String getJavascriptEnd() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        if (!this.isXhtml() && "true".equals(this.htmlComment)) {
            sb.append(HTML_END_COMMENT);
        }
        if (this.isXhtml() && "true".equalsIgnoreCase(this.cdata)) {
            sb.append("//]]>\r\n");
        }
        sb.append("</script>\n\n");
        return sb.toString();
    }

    protected String renderStartElement() {
        StringBuffer start = new StringBuffer("<script type=\"text/javascript\"");
        if (!this.isXhtml() && this.scriptLanguage) {
            start.append(" language=\"Javascript1.1\"");
        }
        if (this.src != null) {
            start.append(" src=\"" + this.src + "\"");
        }
        start.append("> \n");
        return start.toString();
    }

    private boolean isXhtml() {
        return true;
    }

    public String getCdata() {
        return this.cdata;
    }

    public void setCdata(String cdata) {
        this.cdata = cdata;
    }

    public boolean getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptLanguage(boolean scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }
}

