/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.web.control;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.MessageResourcesFactory;

public class PropertyMessageResources
extends MessageResources {
    private static final long serialVersionUID = 1L;
    protected HashMap locales = new HashMap();
    protected HashMap messages = new HashMap();

    public PropertyMessageResources(MessageResourcesFactory factory, String config) {
        super(factory, config);
        this.log("Initializing, config='" + config + "'");
    }

    public PropertyMessageResources(MessageResourcesFactory factory, String config, boolean returnNull) {
        super(factory, config, returnNull);
        this.log("Initializing, config='" + config + "', returnNull=" + returnNull);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage(Locale locale, String key) {
        HashMap hashMap;
        this.log("getMessage(" + locale + "," + key + ")");
        String localeKey = this.localeKey(locale);
        String originalKey = this.messageKey(localeKey, key);
        String messageKey = null;
        String message = null;
        int underscore = 0;
        boolean addIt = false;
        while (true) {
            this.loadLocale(localeKey);
            messageKey = this.messageKey(localeKey, key);
            hashMap = this.messages;
            synchronized (hashMap) {
                message = (String)this.messages.get(messageKey);
                if (message != null) {
                    if (addIt) {
                        this.messages.put(originalKey, message);
                    }
                    return message;
                }
            }
            addIt = true;
            underscore = localeKey.lastIndexOf("_");
            if (underscore < 0) break;
            localeKey = localeKey.substring(0, underscore);
        }
        if (!this.defaultLocale.equals(locale)) {
            localeKey = this.localeKey(this.defaultLocale);
            messageKey = this.messageKey(localeKey, key);
            this.loadLocale(localeKey);
            hashMap = this.messages;
            synchronized (hashMap) {
                message = (String)this.messages.get(messageKey);
                if (message != null) {
                    this.messages.put(originalKey, message);
                    return message;
                }
            }
        }
        localeKey = "";
        messageKey = this.messageKey(localeKey, key);
        this.loadLocale(localeKey);
        hashMap = this.messages;
        synchronized (hashMap) {
            message = (String)this.messages.get(messageKey);
            if (message != null) {
                this.messages.put(originalKey, message);
                return message;
            }
        }
        if (this.returnNull) {
            return null;
        }
        return "???" + this.messageKey(locale, key) + "???";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void loadLocale(String localeKey) {
        this.log("loadLocale(" + localeKey + ")");
        if (this.locales.get(localeKey) != null) {
            return;
        }
        this.locales.put(localeKey, localeKey);
        Properties props = new Properties();
        String[] nameArray = this.config.split(",");
        for (int i = 0; i < nameArray.length; ++i) {
            String name = nameArray[i].replace('.', '/');
            if (localeKey.length() > 0) {
                name = name + "_" + localeKey;
            }
            name = name + ".properties";
            InputStream is = null;
            this.log("  Loading resource '" + name + "'");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            is = classLoader.getResourceAsStream(name);
            Properties properties = new Properties();
            if (is != null) {
                try {
                    properties.load(is);
                }
                catch (IOException e) {
                    this.log("loadLocale()", e);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        this.log("loadLocale()", e);
                    }
                }
            }
            this.log("  Loading resource completed");
            props.putAll((Map<?, ?>)properties);
        }
        HashMap hashMap = this.messages;
        synchronized (hashMap) {
            Iterator<Object> names = props.keySet().iterator();
            while (names.hasNext()) {
                String key = (String)names.next();
                this.log("  Saving message key '" + this.messageKey(localeKey, key));
                this.messages.put(this.messageKey(localeKey, key), props.getProperty(key));
            }
        }
    }
}

