/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.sysframework.web.control;

import com.sinosoft.sysframework.common.util.StringUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionFilter
implements Filter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final String FILTER_TAG = "sinosoft.servlet.session.filter";
    Map ignoreServlet = Collections.synchronizedMap(new HashMap());

    public void destroy() {
        this.ignoreServlet.clear();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletResponse) || !(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        if (request.getAttribute(FILTER_TAG) != null) {
            chain.doFilter(request, response);
            return;
        }
        request.setAttribute(FILTER_TAG, (Object)"true");
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String actionType = httpServletRequest.getParameter("actionType");
        HttpSession session = httpServletRequest.getSession(false);
        String servletPath = httpServletRequest.getServletPath();
        if (servletPath != null && this.ignoreServlet.containsKey(servletPath)) {
            chain.doFilter(request, response);
            return;
        }
        if (session == null) {
            if (actionType != null && actionType.equalsIgnoreCase("login")) {
                chain.doFilter(request, response);
                return;
            }
            request.getRequestDispatcher("/common/Login.jsp").forward(request, response);
            return;
        }
        if (session.getAttribute("user") == null) {
            if (actionType != null && actionType.equalsIgnoreCase("login")) {
                chain.doFilter(request, response);
                return;
            }
            request.getRequestDispatcher("/common/Login.jsp").forward(request, response);
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String ignoreServletPath = filterConfig.getInitParameter("ignoreServlet");
        if (ignoreServletPath != null) {
            this.logger.info((Object)("IgnoreServlet=" + ignoreServletPath));
            this.ignoreServlet.putAll(StringUtils.toMap(ignoreServletPath, ","));
        }
    }
}

