/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.film.service;

import com.sinosoft.film.vo.BaseData;
import com.sinosoft.film.vo.BaseVo;
import com.sinosoft.film.vo.MetaData;
import com.sinosoft.platform.ipservice.IpSelectAction;
import com.sinosoft.platform.ipservice.dto.domain.IpServiceConfigDto;
import java.util.List;

public class ImageService_sales {
    public String createXml(BaseVo baseVo, List<MetaData> metaDataList) {
        BaseData baseData = new BaseData();
        baseData.setOrgCode(baseVo.getOrgCode());
        baseData.setOrgName(baseVo.getOrgName());
        baseData.setUserName(baseVo.getUserName());
        baseData.setUserCode(baseVo.getUserCode());
        baseData.setRoleCode(baseVo.getRoleCode());
        baseData.setDataList(metaDataList);
        return this.createXML(baseData);
    }

    private String createXML(BaseData data) {
        StringBuffer xmlStr = new StringBuffer("<?xml version='1.0' encoding='UTF-8'?>");
        xmlStr.append("<root>");
        xmlStr.append("  <BASE_DATA>");
        if (data != null) {
            xmlStr.append("     <USER_CODE>" + data.getUserCode() + "</USER_CODE>");
            xmlStr.append("     <USER_NAME>" + data.getUserName() + "</USER_NAME>");
            xmlStr.append("     <ORG_CODE>" + data.getOrgCode() + "</ORG_CODE>");
            xmlStr.append("     <ORG_NAME>" + data.getOrgName() + "</ORG_NAME>");
            xmlStr.append("     <ROLE_CODE>" + data.getRoleCode() + "</ROLE_CODE>");
        }
        xmlStr.append("   </BASE_DATA>");
        xmlStr.append("   <META_DATA>");
        if (data.getDataList() != null && data.getDataList().size() > 0) {
            for (MetaData metaData : data.getDataList()) {
                xmlStr.append("     <BATCH>");
                xmlStr.append("       <APP_CODE>" + metaData.getAppCode() + "</APP_CODE>");
                xmlStr.append("       <APP_NAME>" + metaData.getAppName() + "</APP_NAME>");
                xmlStr.append("       <BUSI_NO>" + metaData.getBusNo() + "</BUSI_NO>");
                xmlStr.append("     </BATCH>");
            }
        }
        xmlStr.append("   </META_DATA>");
        xmlStr.append("</root>");
        return xmlStr.toString();
    }

    public String getServerUrl() {
        IpServiceConfigDto filmIpServiceDto = IpSelectAction.getIpInfoBeanByKeyAndNetType((String)"imageUrl", (String)"0");
        String filemanagerUrl = String.valueOf(filmIpServiceDto.getProteclType()) + filmIpServiceDto.getServerIp() + ":" + filmIpServiceDto.getServerPort();
        return filemanagerUrl;
    }
}

