package com.sinosoftgz.api.docs.poc.demo.controller;



import com.sinosoftgz.api.docs.poc.demo.dto.DemoDTO;
import com.sinosoftgz.api.docs.poc.demo.request.DemoReq;
import com.sinosoftgz.api.docs.poc.demo.request.query.DemoQueryReq;
import com.sinosoftgz.api.docs.poc.demo.response.DemoResp;
import com.sinosoftgz.api.docs.poc.demo.response.query.DemoQueryResp;
import com.sinosoftgz.api.docs.poc.demo.vo.DemoVO;
import com.sinosoftgz.global.common.request.BaseRequest;
import com.sinosoftgz.global.common.request.page.PageQueryRequest;
import com.sinosoftgz.global.common.response.BaseResponse;
import com.sinosoftgz.global.common.response.page.ResultPage;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 样例程序前端控制器
 *
 * @author Roney
 * @since 2021-10-26
 * Controller不允许放入复杂的业务逻辑处理，只可以进行简单的数据转换，复杂业务逻辑处理，请统一放在业务逻辑层
 */
@RestController
@RequestMapping("/demo/demo")
public class DemoController {


    /**
     * 样例简单的增加
     * 直接从请求VO转换成DTO
     *
     * @param demoVO
     * @return
     */
    @PostMapping("simpleAdd")
    public BaseResponse<DemoResp> simpleAddDemo(@Valid @RequestBody DemoVO demoVO) {
        return this.addDemo(demoVO);
    }

    /**
     * 样例复杂的增加
     * VO包含集合等对象，返回参数增加其他信息
     *
     * @param demoReq
     * @return
     */
    @PostMapping("complexAdd")
    public BaseResponse<DemoResp> complexAddDemo(@Valid @RequestBody DemoReq demoReq) {
        return BaseResponse.ok();
    }

    /**
     * 样例程序增加
     *
     * @param demoVO
     * @return
     */
    @PostMapping("add")
    public BaseResponse<DemoResp> addDemo(@Valid @RequestBody DemoVO demoVO) {
        return BaseResponse.ok();
    }

    /**
     * 样例程序修改
     *
     * @param demoVO
     * @return
     */
    @PostMapping("update")
    public BaseResponse<DemoResp> updateDemo(@Valid @RequestBody DemoVO demoVO) {
        return BaseResponse.ok();
    }

    /**
     * 样例程序查询 （不分页）
     *
     * @param baseRequest
     * @return
     */
    @PostMapping("find")
    public BaseResponse<DemoQueryResp> findDemo(@Valid @RequestBody BaseRequest<DemoQueryReq> baseRequest) {
        return BaseResponse.ok();
    }

    /**
     * 样例程序根据ID查询
     *
     * @param id
     * @return
     */
    @PostMapping("findById")
    public BaseResponse<DemoResp> findById(@RequestParam("id") String id) {
        return BaseResponse.ok();
    }

    /**
     * 样例程序根据id删除
     *
     * @param id
     * @return
     */
    @PostMapping("deleteById")
    public BaseResponse<DemoResp> deleteById(@RequestParam("id") String id) {
        return BaseResponse.ok();
    }

    /**
     * 样例程序分页查询
     * 返回DTO对象
     *
     * @param demoQueryPageReq
     * @return
     */
    @PostMapping("findByPage")
    public BaseResponse<ResultPage<DemoDTO>> findByPage(@RequestBody PageQueryRequest<DemoDTO> demoQueryPageReq) {
        return BaseResponse.ok();
    }

    /**
     * 样例程序分页查询
     * 返回VO对象
     *
     * @param demoQueryPageReq
     * @return
     */
    @PostMapping("findByPageVO")
    public BaseResponse<ResultPage<DemoVO>> findByPageDemoVO(@RequestBody PageQueryRequest<DemoDTO> demoQueryPageReq) {
        return BaseResponse.ok();
    }
}
