//package com.sinosoftgz.starter.ehcache.api;
//
//import com.google.common.collect.Maps;
//import com.sinosoftgz.starter.ehcache.constants.EhcacheConstants;
//import com.sinosoftgz.starter.ehcache.utils.EhcacheUtils;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.beans.factory.annotation.Value;
//import org.springframework.util.StringUtils;
//import org.springframework.web.bind.annotation.*;
//
//import javax.annotation.Resource;
//import java.util.Arrays;
//import java.util.Map;
//
///**
// * @Author: Roney
// * @CreateTime: 2021-10-12 09:52
// * @Description: 操作ehcache接口(生产环境一般是无法使用客户端进行连接ehcache并且不允许直接使用代码删除ehcache数据,只能使用过期的策略)
// */
//
//@RestController
//@RequestMapping(EhcacheConstants.APP_BASE_CONTEXT + "/operation")
//@Slf4j
//public class EhcacheToolController {
//
//    private static final String DELETE_SUCCESS_MESSAGE = "删除ehcache key: %s 成功";
//
//    private static final String EXPIRE_SUCCESS_MESSAGE = "过期ehcache key: %s 成功，剩余过期时常:%s s (单位秒)";
//
//    private static final String DELETE_ERROR_MESSAGE = "删除ehcache key: %s 发生异常";
//
//    private static final String EXPIRE_ERROR_MESSAGE = "过期ehcache key: %s 发生异常";
//
//    private static final String CHECK_KEY_FAIL_MESSAGE = "不存在ehcache key: %s ";
//
//    @Value("${operation.ehcache.cache.key.password:sinosoftgz..@123ddf}")
//    private String operationEhcacheCacheKeyPassword;
//
//    private static String MESSAGE = "MESSAGE";
//
//
//    @Resource
//    EhcacheUtils ehcacheUtils;
//
//    /**
//     * ehcache key delete
//     *
//     * @param ehcacheKeys
//     * @param deleteCacheKeyPassword
//     * @return
//     */
//    @RequestMapping(value = "/delete", method = RequestMethod.GET)
//    @ResponseBody
//    public Map delete(@RequestParam(name = "ehcacheKeys", required = true) String[] ehcacheKeys, @RequestParam(name = "deleteCacheKeyPassword", required = true) String deleteCacheKeyPassword) {
//        Map resultMaps = Maps.newConcurrentMap();
//        if (StringUtils.isEmpty(deleteCacheKeyPassword)) {
//            resultMaps.put(MESSAGE, "删除ehcacheKey,请提供密码！！");
//            return resultMaps;
//        }
//        if (!operationEhcacheCacheKeyPassword.equals(deleteCacheKeyPassword)) {
//            resultMaps.put(MESSAGE, "删除ehcacheKey,密码不正确！！");
//            return resultMaps;
//        }
//
//        Arrays.asList(ehcacheKeys).parallelStream().forEach(ehcacheKey -> {
//            try {
//                if (ehcacheUtils.hasKey(ehcacheKey)) {
//                    ehcacheUtils.delete(ehcacheKey);
//                    resultMaps.put(ehcacheKey, String.format(DELETE_SUCCESS_MESSAGE, ehcacheKey));
//                } else {
//                    resultMaps.put(ehcacheKey, String.format(CHECK_KEY_FAIL_MESSAGE, ehcacheKey));
//                }
//            } catch (Exception e) {
//                log.error("删除ehcache发生异常:", e);
//                resultMaps.put(ehcacheKey, String.format(DELETE_ERROR_MESSAGE, ehcacheKey));
//            }
//        });
//        return resultMaps;
//    }
//
//
//    /**
//     * ehcache key expire
//     * 备注：生产环境部分公司，ehcache key 设置不能直接删除
//     *
//     * @param ehcacheKeys
//     * @param expireCacheKeyPassword
//     * @return
//     */
//    @RequestMapping(value = "/expire", method = RequestMethod.GET)
//    @ResponseBody
//    public Map expire(@RequestParam(name = "ehcacheKeys", required = true) String[] ehcacheKeys, @RequestParam(name = "expireCacheKeyPassword", required = true) String expireCacheKeyPassword) {
//        Map resultMaps = Maps.newConcurrentMap();
//
//        if (StringUtils.isEmpty(expireCacheKeyPassword)) {
//            resultMaps.put(MESSAGE, "过期ehcacheKey,请提供密码！！");
//            return resultMaps;
//        }
//        if (!operationEhcacheCacheKeyPassword.equals(expireCacheKeyPassword)) {
//            resultMaps.put(MESSAGE, "过期ehcacheKey,密码不正确！！");
//            return resultMaps;
//        }
//
//        Arrays.asList(ehcacheKeys).parallelStream().forEach(ehcacheKey -> {
//            try {
//                if (ehcacheUtils.hasKey(ehcacheKey)) {
//                    ehcacheUtils.expire(ehcacheKey, 1);
//                    resultMaps.put(ehcacheKey, String.format(EXPIRE_SUCCESS_MESSAGE, ehcacheKey, ehcacheUtils.getExpire(ehcacheKey)));
//                } else {
//                    resultMaps.put(ehcacheKey, String.format(CHECK_KEY_FAIL_MESSAGE, ehcacheKey));
//                }
//            } catch (Exception e) {
//                log.error("删除ehcache发生异常:", e);
//                resultMaps.put(ehcacheKey, String.format(EXPIRE_ERROR_MESSAGE, ehcacheKey));
//            }
//        });
//
//        return resultMaps;
//    }
//}
