package com.sinosoftgz.starter.ehcache.constants;

/**
 * @author: Roney
 * @date: 2022-04-06 11:38
 * @description: 常量定义
 */
public abstract class EhcacheConstants {

    /**
     * http接口统一上下文
     */
    public static final String APP_BASE_CONTEXT = "/ehcache";

    /**
     * EHCACHE XML 文件名称
     */
    public static final String EHCACHE_XML_NAME = "ehcache.xml";

    /**
     * 元素最大数量
     */
    public static final int MAX_ELEMENTS_IN_MEMORY = 1000;

    /**
     * 是否把溢出数据持久化到硬盘
     */
    public static final boolean OVER_FLOW_TO_DISK = true;

    /**
     * 是否会死亡
     */
    public static final boolean ETERNAL = false;

    /**
     * 缓存间歇时间
     */
    public static final int TIME_TO_IDLE_SECONDS = 300;

    /**
     * 缓存存活时间
     */
    public static final int TIME_TO_LIVE_SECONDS = 600000;

    /**
     * 是否需要持久化到硬盘
     */
    public static final boolean DISK_PERSISTENT = false;

    /**
     * 内存存取策略
     */
    public static final String MEMORY_STORE_EVICTION_POLICY = "LRU";
}
