/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.ehcache.utils;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcacheUtils {
    private static final Logger log = LoggerFactory.getLogger(EhcacheUtils.class);
    static CacheManager manager = null;

    public static <T extends Serializable> void put(String cacheName, String key, T value) {
        Cache cache = EhcacheUtils.checkCache(cacheName);
        Element e = new Element((Serializable)((Object)key), value);
        cache.put(e);
        cache.flush();
    }

    public static <T extends Serializable> void put(String cacheName, String key, T value, boolean eternal) {
        Cache cache = EhcacheUtils.checkCache(cacheName);
        Element element = new Element((Serializable)((Object)key), value);
        element.setEternal(eternal);
        cache.put(element);
        cache.flush();
    }

    public static <T extends Serializable> void put(String cacheName, String key, T value, int timeToLiveSeconds, int timeToIdleSeconds) {
        Cache cache = EhcacheUtils.checkCache(cacheName);
        Element element = new Element((Serializable)((Object)key), value);
        element.setTimeToLive(timeToLiveSeconds);
        element.setTimeToIdle(timeToIdleSeconds);
        cache.put(element);
        cache.flush();
    }

    public static Object get(String cacheName, String key) {
        Cache cache = EhcacheUtils.checkCache(cacheName);
        Element e = cache.get((Serializable)((Object)key));
        if (e != null) {
            return e.getObjectValue();
        }
        return null;
    }

    public static void remove(String cacheName, String key) {
        Cache cache = EhcacheUtils.checkCache(cacheName);
        cache.remove((Serializable)((Object)key));
    }

    public static void removeAll(String cacheName, Collection<String> keys) {
        Cache cache = EhcacheUtils.checkCache(cacheName);
        cache.removeAll(keys);
    }

    public static void clearAll() {
        manager.clearAll();
    }

    private static Cache checkCache(String cacheName) {
        Cache cache = manager.getCache(cacheName);
        if (null == cache) {
            throw new IllegalArgumentException("name=[" + cacheName + "],\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u7f13\u5b58\u7ec4,\u8bf7\u67e5\u770b" + "ehcache.xml");
        }
        return cache;
    }

    static {
        try {
            manager = CacheManager.create((InputStream)EhcacheUtils.class.getClassLoader().getResourceAsStream("ehcache.xml"));
        }
        catch (CacheException e) {
            log.error("\u83b7\u53d6{}\u5931\u8d25", (Object)"ehcache.xml", (Object)e.getMessage());
        }
    }
}

