/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.hazelcast.config;

import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.sinosoftgz.starter.hazelcast.properties.HazelcastProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={HazelcastProperties.class})
@Import(value={})
@ConditionalOnProperty(prefix="hazelcast", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class HazelcastConfiguration {
    @Autowired
    HazelcastProperties hazelcastProperties;

    @Bean
    public HazelcastInstance hazelcastInstance() {
        Config config = new Config();
        config.getGroupConfig().setName(this.hazelcastProperties.getAppName());
        String[] hazelcastIps = this.hazelcastProperties.getHazelcastIps();
        if (hazelcastIps == null || hazelcastIps.length == 0) {
            config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(true);
        } else {
            config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
            TcpIpConfig tcpIpConfig = config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(true);
            for (String hazelcastIp : hazelcastIps) {
                tcpIpConfig.addMember(hazelcastIp);
            }
        }
        MapConfig mapConfig = config.getMapConfig("getUserInfo");
        mapConfig.setTimeToLiveSeconds(7200);
        mapConfig.setMaxIdleSeconds(5400);
        mapConfig.setEvictionPolicy(EvictionPolicy.NONE);
        mapConfig.setMaxSizeConfig(new MaxSizeConfig(10000, MaxSizeConfig.MaxSizePolicy.PER_NODE));
        mapConfig.setBackupCount(0);
        QueueConfig queueConfig = config.getQueueConfig("default");
        queueConfig.setMaxSize(100000);
        return Hazelcast.newHazelcastInstance((Config)config);
    }
}

