package com.sinosoftgz.starter.hazelcast.config;

import com.hazelcast.config.*;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.sinosoftgz.starter.hazelcast.properties.HazelcastProperties;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import java.util.Arrays;

/**
 * @author: Roney
 * @date: 2021-10-14 14:41
 * @description: HazelcastConfiguration
 */
@Configuration
@EnableConfigurationProperties({HazelcastProperties.class})
@Import({
})
@ConditionalOnProperty(prefix = HazelcastProperties.HAZELCAST_PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
public class HazelcastConfiguration {


    private HazelcastProperties hazelcastProperties;

    public HazelcastConfiguration(final HazelcastProperties hazelcastProperties) {
        this.hazelcastProperties = hazelcastProperties;
    }

    @Bean
    public HazelcastInstance hazelcastInstance() {
        String[] hazelcastIps = hazelcastProperties.getHazelcastIps();
        Config config = new Config();
        config.setClusterName(hazelcastProperties.getClusterName());

        if (hazelcastIps == null || hazelcastIps.length == 0) {
            config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(true);
        } else {
            config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
            TcpIpConfig tcpIpConfig = config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(true);
            tcpIpConfig.setMembers(Arrays.asList(hazelcastIps));
        }

        return Hazelcast.newHazelcastInstance(config);
    }


}
