package com.sinosoftgz.starter.hazelcast.properties;

import lombok.Data;

import org.springframework.boot.context.properties.ConfigurationProperties;


/**
 * @author: Roney
 * @date: 2021-10-14 14:39
 * @description: Hazelcast Properties
 */
@ConfigurationProperties(prefix = HazelcastProperties.HAZELCAST_PREFIX)
@Data
public class HazelcastProperties {


    public static final String HAZELCAST_PREFIX = "hazelcast";

    /**
     * 是否开启
     * 默认开启
     */
    private boolean enabled = true;

    /**
     * clusterName名称，默认是spring-boot-app-cluster
     */
    private String clusterName = "spring-boot-app-cluster";

    /**
     * hazelcast ip 地址
     */
    private String[] hazelcastIps;

}
