/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.hazelcast.config;

import com.hazelcast.config.Config;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.sinosoftgz.starter.hazelcast.properties.HazelcastProperties;
import java.util.Arrays;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={HazelcastProperties.class})
@Import(value={})
@ConditionalOnProperty(prefix="hazelcast", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class HazelcastConfiguration {
    private HazelcastProperties hazelcastProperties;

    public HazelcastConfiguration(HazelcastProperties hazelcastProperties) {
        this.hazelcastProperties = hazelcastProperties;
    }

    @Bean
    public HazelcastInstance hazelcastInstance() {
        String[] hazelcastIps = this.hazelcastProperties.getHazelcastIps();
        Config config = new Config();
        config.setClusterName(this.hazelcastProperties.getClusterName());
        if (hazelcastIps == null || hazelcastIps.length == 0) {
            config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(true);
        } else {
            config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
            TcpIpConfig tcpIpConfig = config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(true);
            tcpIpConfig.setMembers(Arrays.asList(hazelcastIps));
        }
        return Hazelcast.newHazelcastInstance((Config)config);
    }
}

