/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.redis.api;

import com.google.common.collect.Maps;
import com.sinosoftgz.starter.redis.utils.RedisUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/redis/operation"})
public class RedisToolController {
    private static final Logger log = LoggerFactory.getLogger(RedisToolController.class);
    private static final String DELETE_SUCCESS_MESSAGE = "\u5220\u9664redis key: %s \u6210\u529f";
    private static final String EXPIRE_SUCCESS_MESSAGE = "\u8fc7\u671fredis key: %s \u6210\u529f\uff0c\u5269\u4f59\u8fc7\u671f\u65f6\u5e38:%s s (\u5355\u4f4d\u79d2)";
    private static final String DELETE_ERROR_MESSAGE = "\u5220\u9664redis key: %s \u53d1\u751f\u5f02\u5e38";
    private static final String EXPIRE_ERROR_MESSAGE = "\u8fc7\u671fredis key: %s \u53d1\u751f\u5f02\u5e38";
    private static final String CHECK_KEY_FAIL_MESSAGE = "\u4e0d\u5b58\u5728redis key: %s ";
    @Value(value="${operation.redis.cache.key.password:sinosoftgz..@123ddf}")
    private String operationRedisCacheKeyPassword;
    private static String MESSAGE = "MESSAGE";
    @Autowired
    RedisUtils redisUtils;

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public Map delete(@RequestParam(name="redisKeys", required=true) String[] redisKeys, @RequestParam(name="deleteCacheKeyPassword", required=true) String deleteCacheKeyPassword) {
        ConcurrentMap resultMaps = Maps.newConcurrentMap();
        if (StringUtils.isEmpty((Object)deleteCacheKeyPassword)) {
            resultMaps.put(MESSAGE, "\u5220\u9664redisKey,\u8bf7\u63d0\u4f9b\u5bc6\u7801\uff01\uff01");
            return resultMaps;
        }
        if (!this.operationRedisCacheKeyPassword.equals(deleteCacheKeyPassword)) {
            resultMaps.put(MESSAGE, "\u5220\u9664redisKey,\u5bc6\u7801\u4e0d\u6b63\u786e\uff01\uff01");
            return resultMaps;
        }
        Arrays.asList(redisKeys).parallelStream().forEach(redisKey -> {
            try {
                if (this.redisUtils.hasKey((String)redisKey)) {
                    this.redisUtils.delete((String)redisKey);
                    resultMaps.put(redisKey, String.format(DELETE_SUCCESS_MESSAGE, redisKey));
                } else {
                    resultMaps.put(redisKey, String.format(CHECK_KEY_FAIL_MESSAGE, redisKey));
                }
            }
            catch (Exception e) {
                log.error("\u5220\u9664redis\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
                resultMaps.put(redisKey, String.format(DELETE_ERROR_MESSAGE, redisKey));
            }
        });
        return resultMaps;
    }

    @RequestMapping(value={"/expire"}, method={RequestMethod.GET})
    @ResponseBody
    public Map expire(@RequestParam(name="redisKeys", required=true) String[] redisKeys, @RequestParam(name="expireCacheKeyPassword", required=true) String expireCacheKeyPassword) {
        ConcurrentMap resultMaps = Maps.newConcurrentMap();
        if (StringUtils.isEmpty((Object)expireCacheKeyPassword)) {
            resultMaps.put(MESSAGE, "\u8fc7\u671fredisKey,\u8bf7\u63d0\u4f9b\u5bc6\u7801\uff01\uff01");
            return resultMaps;
        }
        if (!this.operationRedisCacheKeyPassword.equals(expireCacheKeyPassword)) {
            resultMaps.put(MESSAGE, "\u8fc7\u671fredisKey,\u5bc6\u7801\u4e0d\u6b63\u786e\uff01\uff01");
            return resultMaps;
        }
        Arrays.asList(redisKeys).parallelStream().forEach(redisKey -> {
            try {
                if (this.redisUtils.hasKey((String)redisKey)) {
                    this.redisUtils.expire((String)redisKey, 1L);
                    resultMaps.put(redisKey, String.format(EXPIRE_SUCCESS_MESSAGE, redisKey, this.redisUtils.getExpire((String)redisKey)));
                } else {
                    resultMaps.put(redisKey, String.format(CHECK_KEY_FAIL_MESSAGE, redisKey));
                }
            }
            catch (Exception e) {
                log.error("\u5220\u9664redis\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
                resultMaps.put(redisKey, String.format(EXPIRE_ERROR_MESSAGE, redisKey));
            }
        });
        return resultMaps;
    }
}

