/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.redis.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sinosoftgz.starter.redis.api.RedisToolController;
import com.sinosoftgz.starter.redis.distributed.DistributedLocker;
import com.sinosoftgz.starter.redis.distributed.RedissonDistributedLocker;
import com.sinosoftgz.starter.redis.properties.RedisLockProperties;
import com.sinosoftgz.starter.redis.utils.RedisLockUtils;
import com.sinosoftgz.starter.redis.utils.RedisUtils;
import com.sinosoftgz.starter.redis.utils.RedissionLockUtils;
import java.lang.reflect.Method;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;

@Configuration
@EnableCaching
@Import(value={RedisToolController.class})
@EnableConfigurationProperties(value={RedisProperties.class, RedisLockProperties.class})
public class RedisConfiguration
extends CachingConfigurerSupport {
    @Bean
    public KeyGenerator wiselyKeyGenerator() {
        return new KeyGenerator(){

            public Object generate(Object target, Method method, Object ... params) {
                StringBuilder sb = new StringBuilder();
                sb.append(target.getClass().getName());
                sb.append(method.getName());
                for (Object obj : params) {
                    sb.append(":").append(String.valueOf(obj));
                }
                return sb.toString().replaceAll("\\.", ":");
            }
        };
    }

    @Bean
    public CacheManager cacheManager(RedisTemplate redisTemplate) {
        return new RedisCacheManager((RedisOperations)redisTemplate);
    }

    @Bean
    public RedisTemplate<String, String> redisTemplate(RedisConnectionFactory factory) {
        StringRedisTemplate template = new StringRedisTemplate(factory);
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper om = new ObjectMapper();
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        om.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        jackson2JsonRedisSerializer.setObjectMapper(om);
        template.setKeySerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setHashKeySerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.afterPropertiesSet();
        return template;
    }

    @Bean
    public RedissonClient redisClient(RedisProperties redisProperties) {
        Config config = new Config();
        if (redisProperties.getSentinel() == null) {
            config.useSingleServer().setAddress("redis://" + redisProperties.getHost() + ":" + redisProperties.getPort());
            ((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setDatabase(redisProperties.getDatabase()).setPassword(redisProperties.getPassword())).setIdleConnectionTimeout(1000)).setConnectTimeout(30000)).setPingTimeout(30000)).setReconnectionTimeout(30000);
        } else {
            String[] redisNodes = redisProperties.getSentinel().getNodes().split(",");
            String masterHost = redisNodes[0];
            String slaveHost1 = redisNodes[1];
            String slaveHost2 = redisNodes[2];
            ((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)config.useSentinelServers().addSentinelAddress(new String[]{"redis://" + masterHost}).addSentinelAddress(new String[]{"redis://" + slaveHost1}).addSentinelAddress(new String[]{"redis://" + slaveHost2}).setDatabase(redisProperties.getDatabase()).setMasterName(redisProperties.getSentinel().getMaster()).setPassword(redisProperties.getPassword())).setMasterConnectionPoolSize(500)).setSlaveConnectionPoolSize(500)).setIdleConnectionTimeout(1000)).setConnectTimeout(30000)).setPingTimeout(30000)).setReconnectionTimeout(30000);
        }
        RedissonClient redissonClient = Redisson.create((Config)config);
        return redissonClient;
    }

    @Bean
    @ConditionalOnProperty(prefix="redis.lock", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public RedisLockUtils redisLockUtils(StringRedisTemplate stringRedisTemplate) {
        RedisLockUtils redisLockUtils = new RedisLockUtils(stringRedisTemplate);
        return redisLockUtils;
    }

    @Bean
    public RedisUtils redisUtils(RedisTemplate redisTemplate) {
        RedisUtils redisUtils = new RedisUtils();
        redisUtils.setRedisTemplate((RedisTemplate<String, Object>)redisTemplate);
        return redisUtils;
    }

    @Bean
    DistributedLocker distributedLocker(RedissonClient redissonClient) {
        RedissonDistributedLocker locker = new RedissonDistributedLocker();
        locker.setRedissonClient(redissonClient);
        RedissionLockUtils.setLocker(locker);
        return locker;
    }
}

