package com.sinosoftgz.starter.redis.api;

import com.google.common.collect.Maps;
import com.sinosoftgz.starter.redis.constants.RedisConstants;
import com.sinosoftgz.starter.redis.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.Map;

/**
 * @Author: Roney
 * @CreateTime: 2021-10-12 09:52
 * @Description: 操作redis接口(生产环境一般是无法使用客户端进行连接redis并且不允许直接使用代码删除redis数据, 只能使用过期的策略)
 */

@RestController
@RequestMapping(RedisConstants.APP_BASE_CONTEXT + "/operation")
@Slf4j
public class RedisToolController {

    private static final String DELETE_SUCCESS_MESSAGE = "删除redis key: %s 成功";

    private static final String EXPIRE_SUCCESS_MESSAGE = "过期redis key: %s 成功，剩余过期时常:%s s (单位秒)";

    private static final String DELETE_ERROR_MESSAGE = "删除redis key: %s 发生异常";

    private static final String EXPIRE_ERROR_MESSAGE = "过期redis key: %s 发生异常";

    private static final String CHECK_KEY_FAIL_MESSAGE = "不存在redis key: %s ";

    @Value("${operation.redis.cache.key.password:sinosoftgz..@123ddf}")
    private String operationRedisCacheKeyPassword;

    private static String MESSAGE = "MESSAGE";


    @Resource
    RedisUtils redisUtils;

    /**
     * redis key delete
     *
     * @param redisKeys
     * @param deleteCacheKeyPassword
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.GET)
    @ResponseBody
    public Map delete(@RequestParam(name = "redisKeys", required = true) String[] redisKeys, @RequestParam(name = "deleteCacheKeyPassword", required = true) String deleteCacheKeyPassword) {
        Map resultMaps = Maps.newConcurrentMap();
        if (StringUtils.isEmpty(deleteCacheKeyPassword)) {
            resultMaps.put(MESSAGE, "删除redisKey,请提供密码！！");
            return resultMaps;
        }
        if (!operationRedisCacheKeyPassword.equals(deleteCacheKeyPassword)) {
            resultMaps.put(MESSAGE, "删除redisKey,密码不正确！！");
            return resultMaps;
        }

        Arrays.asList(redisKeys).parallelStream().forEach(redisKey -> {
            try {
                if (redisUtils.hasKey(redisKey)) {
                    redisUtils.delete(redisKey);
                    resultMaps.put(redisKey, String.format(DELETE_SUCCESS_MESSAGE, redisKey));
                } else {
                    resultMaps.put(redisKey, String.format(CHECK_KEY_FAIL_MESSAGE, redisKey));
                }
            } catch (Exception e) {
                log.error("删除redis发生异常:", e);
                resultMaps.put(redisKey, String.format(DELETE_ERROR_MESSAGE, redisKey));
            }
        });
        return resultMaps;
    }


    /**
     * redis key expire
     * 备注：生产环境部分公司，redis key 设置不能直接删除
     *
     * @param redisKeys
     * @param expireCacheKeyPassword
     * @return
     */
    @RequestMapping(value = "/expire", method = RequestMethod.GET)
    @ResponseBody
    public Map expire(@RequestParam(name = "redisKeys", required = true) String[] redisKeys, @RequestParam(name = "expireCacheKeyPassword", required = true) String expireCacheKeyPassword) {
        Map resultMaps = Maps.newConcurrentMap();

        if (StringUtils.isEmpty(expireCacheKeyPassword)) {
            resultMaps.put(MESSAGE, "过期redisKey,请提供密码！！");
            return resultMaps;
        }
        if (!operationRedisCacheKeyPassword.equals(expireCacheKeyPassword)) {
            resultMaps.put(MESSAGE, "过期redisKey,密码不正确！！");
            return resultMaps;
        }

        Arrays.asList(redisKeys).parallelStream().forEach(redisKey -> {
            try {
                if (redisUtils.hasKey(redisKey)) {
                    redisUtils.expire(redisKey, 1);
                    resultMaps.put(redisKey, String.format(EXPIRE_SUCCESS_MESSAGE, redisKey, redisUtils.getExpire(redisKey)));
                } else {
                    resultMaps.put(redisKey, String.format(CHECK_KEY_FAIL_MESSAGE, redisKey));
                }
            } catch (Exception e) {
                log.error("删除redis发生异常:", e);
                resultMaps.put(redisKey, String.format(EXPIRE_ERROR_MESSAGE, redisKey));
            }
        });

        return resultMaps;
    }
}
