package com.sinosoftgz.starter.redis.config;


import cn.hutool.core.util.StrUtil;

import com.sinosoftgz.starter.redis.api.RedisToolController;
import com.sinosoftgz.starter.redis.properties.RedisLockProperties;
import com.sinosoftgz.starter.redis.utils.RedisLockUtils;
import com.sinosoftgz.starter.redis.utils.RedisUtils;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

import java.lang.reflect.Method;

/**
 * @Author: Roney
 * @CreateTime: 2021-10-12 09:52
 * @Description: 注入配置类
 */

@Configuration
@EnableCaching
@Import({
        JacksonConfiguration.class,
        FastJsonConfiguration.class,
        KryoConfiguration.class,
        RedisToolController.class
})
@EnableConfigurationProperties({RedisProperties.class, RedisLockProperties.class})
public class RedisConfiguration extends CachingConfigurerSupport {

    @Bean
    public KeyGenerator wiselyKeyGenerator() {
        return new KeyGenerator() {
            public Object generate(Object target, Method method, Object... params) {
                StringBuilder sb = new StringBuilder();
                sb.append(target.getClass().getName());
                sb.append(method.getName());
                for (Object obj : params) {
                    sb.append(StrUtil.COLON).append(String.valueOf(obj));
                }
                return sb.toString().replaceAll(StrUtil.BACKSLASH + StrUtil.DOT, StrUtil.COLON);
            }
        };
    }


    @Bean
    @ConditionalOnProperty(prefix = RedisLockProperties.REDIS_LOCK_PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
    public RedisLockUtils redisLockUtils(StringRedisTemplate stringRedisTemplate) {
        RedisLockUtils redisLockUtils = new RedisLockUtils(stringRedisTemplate);
        return redisLockUtils;
    }

    @Bean
    public RedisUtils redisUtils(RedisTemplate redisTemplate) {
        RedisUtils redisUtils = new RedisUtils();
        redisUtils.setRedisTemplate(redisTemplate);
        return redisUtils;
    }

    /**
     * 装配locker类，并将实例注入到RedissionLockUtils中
     *
     * @return
     */
//    @Bean
//    DistributedLocker distributedLocker(RedissonClient redissonClient) {
//        DistributedLocker locker = new RedissonDistributedLocker();
//        locker.setRedissonClient(redissonClient);
//        RedissionLockUtils.setLocker(locker);
//        return locker;
//    }

}
