package com.sinosoftgz.starter.redis.distributed;

import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;

import java.util.concurrent.TimeUnit;

/**
 * Created by Roney on 2019/11/19.
 *
 * @author Roney
 * @date 2019-11-19 15:51
 */
public interface DistributedLocker {

    /**
     * 加锁
     *
     * @param lockKey
     * @return
     */
    RLock lock(String lockKey);

    /**
     * 带超时的锁
     *
     * @param lockKey
     * @param timeout 超时时间   单位：秒
     * @return
     */
    RLock lock(String lockKey, long timeout);

    /**
     * 带超时的锁
     *
     * @param lockKey
     * @param unit    时间单位
     * @param timeout 超时时间
     * @return
     */
    RLock lock(String lockKey, TimeUnit unit, long timeout);

    /**
     * 尝试获取锁
     *
     * @param lockKey
     * @param unit      时间单位
     * @param waitTime  最多等待时间
     * @param leaseTime 上锁后自动释放锁时间
     * @return
     */
    boolean tryLock(String lockKey, TimeUnit unit, long waitTime, long leaseTime);

    /**
     * 释放锁
     *
     * @param lockKey
     */
    void unlock(String lockKey);

    /**
     * 释放锁
     *
     * @param lock
     */
    void unlock(RLock lock);

    /**
     * 设置redissonClient
     *
     * @param redissonClient
     */
    void setRedissonClient(RedissonClient redissonClient);
}
