package com.sinosoftgz.starter.redis.properties;

import cn.hutool.core.util.StrUtil;
import com.sinosoftgz.starter.redis.constants.RedisConstants;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author: Roney
 * @date: 2021-10-13 11:13
 * @description: redis 锁配置
 */

@ConfigurationProperties(prefix = RedisLockProperties.REDIS_LOCK_PREFIX)
@Data
public class RedisLockProperties {

    public static final String REDIS_LOCK_PREFIX = RedisConstants.REDIS_PREFIX + StrUtil.DOT + "lock";

    /**
     * 是否开启redis锁
     * 默认开启
     */
    private boolean enabled = true;
    /**
     * redis锁前缀
     */
    private String prefix = "redis:lock:keys:";


    /**
     * 全局默认锁的超时时间，单位毫秒，默认60000
     */
    private long timeout = 60 * 1000;

}
